/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.cheaptime.domain.CheapTimeSolution;
import org.optaplanner.examples.cheaptime.domain.Machine;
import org.optaplanner.examples.cheaptime.domain.MachineCapacity;
import org.optaplanner.examples.cheaptime.domain.PeriodPowerCost;
import org.optaplanner.examples.cheaptime.domain.Resource;
import org.optaplanner.examples.cheaptime.domain.Task;
import org.optaplanner.examples.cheaptime.domain.TaskAssignment;
import org.optaplanner.examples.cheaptime.domain.TaskRequirement;
import org.optaplanner.examples.cheaptime.persistence.CheapTimeDao;
import org.optaplanner.examples.cheaptime.solver.CheapTimeCostCalculator;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionImporter;

public class CheapTimeImporter
extends AbstractTxtSolutionImporter {
    public static void main(String[] args) {
        CheapTimeImporter importer = new CheapTimeImporter();
        importer.convert("sample01", "sample01.xml");
        importer.convert("sample02", "sample02.xml");
        importer.convert("sample03", "sample03.xml");
        importer.convert("sample04", "sample04.xml");
        importer.convert("sample05", "sample05.xml");
        importer.convert("sample06", "sample06.xml");
        importer.convert("sample07", "sample07.xml");
        importer.convert("sample08", "sample08.xml");
        importer.convert("sample09", "sample09.xml");
        importer.convert("instance00", "instance00.xml");
        importer.convert("instance01", "instance01.xml");
        importer.convert("instance02", "instance02.xml");
        importer.convert("instance03", "instance03.xml");
        importer.convert("instance04", "instance04.xml");
        importer.convert("instance05", "instance05.xml");
        importer.convert("instance06", "instance06.xml");
        importer.convert("instance07", "instance07.xml");
        importer.convert("instance08", "instance08.xml");
        importer.convert("instance09", "instance09.xml");
        importer.convert("instance10", "instance10.xml");
        importer.convert("instance11", "instance11.xml");
        importer.convert("instance12", "instance12.xml");
        importer.convert("instance13", "instance13.xml");
        importer.convert("instance14", "instance14.xml");
        importer.convert("instance15", "instance15.xml");
        importer.convert("instance16", "instance16.xml");
        importer.convert("instance17", "instance17.xml");
        importer.convert("instance18", "instance18.xml");
        importer.convert("instance19", "instance19.xml");
        importer.convert("instance20", "instance20.xml");
        importer.convert("instance21", "instance21.xml");
        importer.convert("instance22", "instance22.xml");
        importer.convert("instance23", "instance23.xml");
        importer.convert("instance24", "instance24.xml");
        importer.convert("instance25", "instance25.xml");
        importer.convert("instance26", "instance26.xml");
        importer.convert("instance27", "instance27.xml");
        importer.convert("instance28", "instance28.xml");
        importer.convert("instance29", "instance29.xml");
        importer.convert("instance30", "instance30.xml");
        importer.convert("instance31", "instance31.xml");
        importer.convert("instance32", "instance32.xml");
        importer.convert("instance33", "instance33.xml");
        importer.convert("instance34", "instance34.xml");
        importer.convert("instance35", "instance35.xml");
        importer.convert("instance36", "instance36.xml");
        importer.convert("instance37", "instance37.xml");
        importer.convert("instance38", "instance38.xml");
        importer.convert("instance39", "instance39.xml");
        importer.convert("instance40", "instance40.xml");
        importer.convert("instance41", "instance41.xml");
        importer.convert("instance42", "instance42.xml");
        importer.convert("instance43", "instance43.xml");
        importer.convert("instance44", "instance44.xml");
        importer.convert("instance45", "instance45.xml");
        importer.convert("instance46", "instance46.xml");
        importer.convert("instance47", "instance47.xml");
        importer.convert("instance48", "instance48.xml");
        importer.convert("instance49", "instance49.xml");
    }

    public CheapTimeImporter() {
        super(new CheapTimeDao());
    }

    @Override
    public boolean isInputFileDirectory() {
        return true;
    }

    @Override
    public String getInputFileSuffix() {
        throw new IllegalStateException("The inputFile is a directory, so there is no suffix.");
    }

    @Override
    public AbstractTxtSolutionImporter.TxtInputBuilder createTxtInputBuilder() {
        return new CheapTimeInputBuilder();
    }

    @Override
    public Solution readSolution(File inputFile) {
        File instanceFile = new File(inputFile, "instance.txt");
        return super.readSolution(instanceFile);
    }

    public static class CheapTimeInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder {
        private CheapTimeSolution solution;
        private int resourceListSize;

        @Override
        public Solution readSolution() throws IOException {
            this.solution = new CheapTimeSolution();
            this.solution.setId(0L);
            int timeResolutionInMinutes = this.readIntegerValue();
            this.solution.setTimeResolutionInMinutes(timeResolutionInMinutes);
            this.solution.setGlobalPeriodRangeFrom(0);
            this.solution.setGlobalPeriodRangeTo(1440 / timeResolutionInMinutes);
            this.readResourceList();
            this.readMachineList();
            this.readTaskList();
            this.readForecastFile();
            this.createTaskAssignmentList();
            this.logger.info("CheapTime {} has {} resources, {} machines, {} periods and {} tasks.", new Object[]{this.getInputId(), this.solution.getResourceList().size(), this.solution.getMachineList().size(), this.solution.getGlobalPeriodRangeTo(), this.solution.getTaskList().size()});
            return this.solution;
        }

        @Override
        public String getInputId() {
            return FilenameUtils.getBaseName((String)this.inputFile.getParentFile().getPath());
        }

        private void readResourceList() throws IOException {
            this.resourceListSize = this.readIntegerValue();
            ArrayList<Resource> resourceList = new ArrayList<Resource>(this.resourceListSize);
            for (int i = 0; i < this.resourceListSize; ++i) {
                Resource resource = new Resource();
                resource.setId(Long.valueOf(i));
                resource.setIndex(i);
                resourceList.add(resource);
            }
            this.solution.setResourceList(resourceList);
        }

        private void readMachineList() throws IOException {
            int machineListSize = this.readIntegerValue();
            ArrayList<Machine> machineList = new ArrayList<Machine>(machineListSize);
            ArrayList<MachineCapacity> machineCapacityList = new ArrayList<MachineCapacity>(machineListSize * this.resourceListSize);
            long machineCapacityId = 0L;
            for (int i = 0; i < machineListSize; ++i) {
                Machine machine = new Machine();
                String[] machineLineTokens = this.splitBySpacesOrTabs(this.readStringValue(), 4);
                machine.setId(Long.parseLong(machineLineTokens[0]));
                machine.setIndex(i);
                machine.setPowerConsumptionMicros(CheapTimeCostCalculator.parseMicroCost(machineLineTokens[1]));
                machine.setSpinUpDownCostMicros(CheapTimeCostCalculator.parseMicroCost(machineLineTokens[2]) + CheapTimeCostCalculator.parseMicroCost(machineLineTokens[3]));
                String[] capacityLineTokens = this.splitBySpacesOrTabs(this.readStringValue(), this.resourceListSize);
                ArrayList<MachineCapacity> machineCapacityListOfMachine = new ArrayList<MachineCapacity>(this.resourceListSize);
                for (int j = 0; j < this.resourceListSize; ++j) {
                    MachineCapacity machineCapacity = new MachineCapacity();
                    machineCapacity.setId(machineCapacityId);
                    ++machineCapacityId;
                    machineCapacity.setMachine(machine);
                    machineCapacity.setResource(this.solution.getResourceList().get(j));
                    machineCapacity.setCapacity(Integer.parseInt(capacityLineTokens[j]));
                    machineCapacityList.add(machineCapacity);
                    machineCapacityListOfMachine.add(machineCapacity);
                }
                machine.setMachineCapacityList(machineCapacityListOfMachine);
                machineList.add(machine);
            }
            this.solution.setMachineList(machineList);
            this.solution.setMachineCapacityList(machineCapacityList);
        }

        private void readTaskList() throws IOException {
            int taskListSize = this.readIntegerValue();
            ArrayList<Task> taskList = new ArrayList<Task>(taskListSize);
            ArrayList<TaskRequirement> taskRequirementList = new ArrayList<TaskRequirement>(taskListSize * this.resourceListSize);
            long taskRequirementId = 0L;
            for (int i = 0; i < taskListSize; ++i) {
                String[] taskLineTokens = this.splitBySpacesOrTabs(this.readStringValue(), 5);
                Task task = new Task();
                task.setId(Long.parseLong(taskLineTokens[0]));
                int duration = Integer.parseInt(taskLineTokens[1]);
                if (duration <= 0) {
                    throw new IllegalArgumentException("Task with id (" + task.getId() + ") has a duration (" + duration + ") which is not 1 or higher.");
                }
                task.setDuration(duration);
                int earliestStart = Integer.parseInt(taskLineTokens[2]);
                if (earliestStart < this.solution.getGlobalPeriodRangeFrom() || earliestStart >= this.solution.getGlobalPeriodRangeTo()) {
                    throw new IllegalArgumentException("Task with id (" + task.getId() + ") has a earliestStart (" + earliestStart + ") which is not between globalPeriodRangeFrom (" + this.solution.getGlobalPeriodRangeFrom() + ") and globalPeriodRangeTo (" + this.solution.getGlobalPeriodRangeTo() + ").");
                }
                task.setStartPeriodRangeFrom(earliestStart);
                int latestEnd = Integer.parseInt(taskLineTokens[3]);
                if (latestEnd < this.solution.getGlobalPeriodRangeFrom() || latestEnd > this.solution.getGlobalPeriodRangeTo()) {
                    throw new IllegalArgumentException("Task with id (" + task.getId() + ") has a latestEnd (" + latestEnd + ") which is not between globalPeriodRangeFrom (" + this.solution.getGlobalPeriodRangeFrom() + ") and globalPeriodRangeTo (" + this.solution.getGlobalPeriodRangeTo() + ").");
                }
                task.setPowerConsumptionMicros(CheapTimeCostCalculator.parseMicroCost(taskLineTokens[4]));
                task.setStartPeriodRangeTo(latestEnd - duration + 1);
                String[] usageLineTokens = this.splitBySpacesOrTabs(this.readStringValue(), this.resourceListSize);
                ArrayList<TaskRequirement> taskRequirementListOfTask = new ArrayList<TaskRequirement>(this.resourceListSize);
                for (int j = 0; j < this.resourceListSize; ++j) {
                    TaskRequirement taskRequirement = new TaskRequirement();
                    taskRequirement.setId(taskRequirementId);
                    ++taskRequirementId;
                    taskRequirement.setTask(task);
                    taskRequirement.setResource(this.solution.getResourceList().get(j));
                    taskRequirement.setResourceUsage(Integer.parseInt(usageLineTokens[j]));
                    taskRequirementList.add(taskRequirement);
                    taskRequirementListOfTask.add(taskRequirement);
                }
                task.setTaskRequirementList(taskRequirementListOfTask);
                taskList.add(task);
            }
            this.solution.setTaskList(taskList);
            this.solution.setTaskRequirementList(taskRequirementList);
        }

        private void readForecastFile() {
            File forecastInputFile = new File(this.inputFile.getParent(), "forecast.txt");
            if (!forecastInputFile.exists()) {
                throw new IllegalArgumentException("The forecastInputFile (" + forecastInputFile + ") for instanceInputFile (" + this.inputFile + ") does not exist.");
            }
            BufferedReader forecastBufferedReader = null;
            try {
                forecastBufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(forecastInputFile), "UTF-8"));
                ForecastInputBuilder forecastInputBuilder = new ForecastInputBuilder();
                forecastInputBuilder.setInputFile(forecastInputFile);
                forecastInputBuilder.setBufferedReader(forecastBufferedReader);
                try {
                    forecastInputBuilder.readSolution();
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Exception in forecastInputFile (" + forecastInputFile + ")", e);
                }
                catch (IllegalStateException e) {
                    throw new IllegalStateException("Exception in forecastInputFile (" + forecastInputFile + ")", e);
                }
            }
            catch (IOException e) {
                try {
                    throw new IllegalArgumentException("Could not read the file (" + forecastInputFile.getName() + ").", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(forecastBufferedReader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)forecastBufferedReader);
        }

        private void createTaskAssignmentList() {
            List<Task> taskList = this.solution.getTaskList();
            ArrayList<TaskAssignment> taskAssignmentList = new ArrayList<TaskAssignment>(taskList.size());
            for (Task task : taskList) {
                TaskAssignment taskAssignment = new TaskAssignment();
                taskAssignment.setId(task.getId());
                taskAssignment.setTask(task);
                taskAssignmentList.add(taskAssignment);
            }
            this.solution.setTaskAssignmentList(taskAssignmentList);
        }

        public class ForecastInputBuilder
        extends AbstractTxtSolutionImporter.TxtInputBuilder {
            @Override
            public Solution readSolution() throws IOException {
                int periodListSize = this.readIntegerValue();
                long periodDurationPerHour = CheapTimeCostCalculator.divideTwoMicros(CheapTimeCostCalculator.toMicroCost(1440L), CheapTimeCostCalculator.toMicroCost((long)periodListSize * 60L));
                ArrayList<PeriodPowerCost> periodPowerCostList = new ArrayList<PeriodPowerCost>(periodListSize);
                for (int i = 0; i < periodListSize; ++i) {
                    String[] taskLineTokens = this.splitBySpacesOrTabs(this.readStringValue(), 2);
                    PeriodPowerCost periodPowerCost = new PeriodPowerCost();
                    int period = Integer.parseInt(taskLineTokens[0]);
                    if (periodPowerCostList.size() != period) {
                        throw new IllegalStateException("The forecast period (" + period + ") does not increment normally and gets a different list index (" + periodPowerCostList.size() + ").");
                    }
                    periodPowerCost.setId(Long.valueOf(period));
                    periodPowerCost.setPeriod(period);
                    long hourlyPowerCostMicros = CheapTimeCostCalculator.parseMicroCost(taskLineTokens[1]);
                    periodPowerCost.setPowerCostMicros(CheapTimeCostCalculator.multiplyTwoMicros(hourlyPowerCostMicros, periodDurationPerHour));
                    periodPowerCostList.add(periodPowerCost);
                }
                CheapTimeInputBuilder.this.solution.setPeriodPowerCostList(periodPowerCostList);
                return null;
            }
        }
    }
}

