/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.solver.score;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.impl.score.director.easy.EasyScoreCalculator;
import org.optaplanner.examples.cheaptime.domain.CheapTimeSolution;
import org.optaplanner.examples.cheaptime.domain.Machine;
import org.optaplanner.examples.cheaptime.domain.PeriodPowerCost;
import org.optaplanner.examples.cheaptime.domain.Task;
import org.optaplanner.examples.cheaptime.domain.TaskAssignment;
import org.optaplanner.examples.cheaptime.domain.TaskRequirement;
import org.optaplanner.examples.cheaptime.solver.CheapTimeCostCalculator;

public class CheapTimeEasyScoreCalculator
implements EasyScoreCalculator<CheapTimeSolution> {
    public HardMediumSoftLongScore calculateScore(CheapTimeSolution solution) {
        if (solution.getGlobalPeriodRangeFrom() != 0) {
            throw new IllegalStateException("The globalPeriodRangeFrom (" + solution.getGlobalPeriodRangeFrom() + ") should be 0.");
        }
        int resourceListSize = solution.getResourceList().size();
        int globalPeriodRangeTo = solution.getGlobalPeriodRangeTo();
        List<Machine> machineList = solution.getMachineList();
        LinkedHashMap machinePeriodListMap = new LinkedHashMap(machineList.size());
        for (Machine machine : machineList) {
            ArrayList<MachinePeriodPart> machinePeriodList = new ArrayList<MachinePeriodPart>(globalPeriodRangeTo);
            for (int period = 0; period < globalPeriodRangeTo; ++period) {
                machinePeriodList.add(new MachinePeriodPart(machine, period, resourceListSize));
            }
            machinePeriodListMap.put(machine, machinePeriodList);
        }
        long mediumScore = 0L;
        long softScore = 0L;
        List<PeriodPowerCost> periodPowerCostList = solution.getPeriodPowerCostList();
        for (TaskAssignment taskAssignment : solution.getTaskAssignmentList()) {
            Machine machine = taskAssignment.getMachine();
            Integer startPeriod = taskAssignment.getStartPeriod();
            if (machine == null || startPeriod == null) continue;
            List machinePeriodList = (List)machinePeriodListMap.get(machine);
            int endPeriod = taskAssignment.getEndPeriod();
            for (int period = startPeriod.intValue(); period < endPeriod; ++period) {
                MachinePeriodPart machinePeriodPart = (MachinePeriodPart)machinePeriodList.get(period);
                machinePeriodPart.addTaskAssignment(taskAssignment);
                PeriodPowerCost periodPowerCost = periodPowerCostList.get(period);
                mediumScore -= CheapTimeCostCalculator.multiplyTwoMicros(taskAssignment.getTask().getPowerConsumptionMicros(), periodPowerCost.getPowerCostMicros());
            }
            softScore -= (long)startPeriod.intValue();
        }
        long hardScore = 0L;
        for (Map.Entry entry : machinePeriodListMap.entrySet()) {
            Machine machine = (Machine)entry.getKey();
            List machinePeriodList = (List)entry.getValue();
            MachinePeriodStatus previousStatus = MachinePeriodStatus.OFF;
            long idleCostMicros = 0L;
            for (int period = 0; period < globalPeriodRangeTo; ++period) {
                PeriodPowerCost periodPowerCost = periodPowerCostList.get(period);
                MachinePeriodPart machinePeriodPart = (MachinePeriodPart)machinePeriodList.get(period);
                boolean active = machinePeriodPart.isActive();
                if (active) {
                    if (previousStatus == MachinePeriodStatus.OFF) {
                        mediumScore -= machine.getSpinUpDownCostMicros();
                    } else if (previousStatus == MachinePeriodStatus.IDLE) {
                        mediumScore -= idleCostMicros;
                        idleCostMicros = 0L;
                    }
                    hardScore += machinePeriodPart.getHardScore();
                    mediumScore -= CheapTimeCostCalculator.multiplyTwoMicros(machine.getPowerConsumptionMicros(), periodPowerCost.getPowerCostMicros());
                    previousStatus = MachinePeriodStatus.ACTIVE;
                    continue;
                }
                if (previousStatus == MachinePeriodStatus.OFF) continue;
                if ((idleCostMicros += CheapTimeCostCalculator.multiplyTwoMicros(machine.getPowerConsumptionMicros(), periodPowerCost.getPowerCostMicros())) > machine.getSpinUpDownCostMicros()) {
                    idleCostMicros = 0L;
                    previousStatus = MachinePeriodStatus.OFF;
                    continue;
                }
                previousStatus = MachinePeriodStatus.IDLE;
            }
        }
        return HardMediumSoftLongScore.valueOf(hardScore, mediumScore, softScore);
    }

    private class MachinePeriodPart {
        private final Machine machine;
        private final int period;
        private boolean active;
        private List<Integer> resourceAvailableList;

        private MachinePeriodPart(Machine machine, int period, int resourceListSize) {
            this.machine = machine;
            this.period = period;
            this.active = false;
            this.resourceAvailableList = new ArrayList<Integer>(resourceListSize);
            for (int i = 0; i < resourceListSize; ++i) {
                this.resourceAvailableList.add(machine.getMachineCapacityList().get(i).getCapacity());
            }
        }

        public boolean isActive() {
            return this.active;
        }

        public void addTaskAssignment(TaskAssignment taskAssignment) {
            this.active = true;
            Task task = taskAssignment.getTask();
            for (int i = 0; i < this.resourceAvailableList.size(); ++i) {
                int resourceAvailable = this.resourceAvailableList.get(i);
                TaskRequirement taskRequirement = task.getTaskRequirementList().get(i);
                this.resourceAvailableList.set(i, resourceAvailable - taskRequirement.getResourceUsage());
            }
        }

        public long getHardScore() {
            long hardScore = 0L;
            for (int resourceAvailable : this.resourceAvailableList) {
                if (resourceAvailable >= 0) continue;
                hardScore += (long)resourceAvailable;
            }
            return hardScore;
        }
    }

    private static enum MachinePeriodStatus {
        OFF,
        IDLE,
        ACTIVE;

    }
}

