/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.domain;

import com.thoughtworks.xstream.annotations.XStreamInclude;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.examination.domain.FollowingExam;
import org.optaplanner.examples.examination.domain.LeadingExam;
import org.optaplanner.examples.examination.domain.Period;
import org.optaplanner.examples.examination.domain.Room;
import org.optaplanner.examples.examination.domain.Topic;
import org.optaplanner.examples.examination.domain.solver.ExamDifficultyWeightFactory;
import org.optaplanner.examples.examination.domain.solver.RoomStrengthWeightFactory;

@PlanningEntity(difficultyWeightFactoryClass=ExamDifficultyWeightFactory.class)
@XStreamInclude(value={LeadingExam.class, FollowingExam.class})
public abstract class Exam
extends AbstractPersistable {
    protected Topic topic;
    protected Room room;

    public Topic getTopic() {
        return this.topic;
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }

    @PlanningVariable(valueRangeProviderRefs={"roomRange"}, strengthWeightFactoryClass=RoomStrengthWeightFactory.class)
    public Room getRoom() {
        return this.room;
    }

    public void setRoom(Room room) {
        this.room = room;
    }

    public abstract Period getPeriod();

    public int getTopicDuration() {
        return this.getTopic().getDuration();
    }

    public int getTopicStudentSize() {
        return this.getTopic().getStudentSize();
    }

    public int getDayIndex() {
        Period period = this.getPeriod();
        if (period == null) {
            return Integer.MIN_VALUE;
        }
        return period.getDayIndex();
    }

    public int getPeriodIndex() {
        Period period = this.getPeriod();
        if (period == null) {
            return Integer.MIN_VALUE;
        }
        return period.getPeriodIndex();
    }

    public int getPeriodDuration() {
        Period period = this.getPeriod();
        if (period == null) {
            return Integer.MIN_VALUE;
        }
        return period.getDuration();
    }

    public boolean isTopicFrontLoadLarge() {
        return this.topic.isFrontLoadLarge();
    }

    public boolean isPeriodFrontLoadLast() {
        Period period = this.getPeriod();
        if (period == null) {
            return false;
        }
        return period.isFrontLoadLast();
    }

    public String getLabel() {
        return Long.toString(this.topic.getId());
    }

    @Override
    public String toString() {
        return this.topic + " @ " + this.getPeriod() + " + " + this.room;
    }
}

