/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.solver.drools;

import java.io.Serializable;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.examples.nurserostering.domain.DayOfWeek;
import org.optaplanner.examples.nurserostering.domain.Employee;
import org.optaplanner.examples.nurserostering.domain.ShiftDate;
import org.optaplanner.examples.nurserostering.domain.WeekendDefinition;
import org.optaplanner.examples.nurserostering.domain.contract.Contract;

public class EmployeeConsecutiveAssignmentStart
implements Comparable<EmployeeConsecutiveAssignmentStart>,
Serializable {
    private Employee employee;
    private ShiftDate shiftDate;

    public EmployeeConsecutiveAssignmentStart(Employee employee, ShiftDate shiftDate) {
        this.employee = employee;
        this.shiftDate = shiftDate;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public ShiftDate getShiftDate() {
        return this.shiftDate;
    }

    public void setShiftDate(ShiftDate shiftDate) {
        this.shiftDate = shiftDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof EmployeeConsecutiveAssignmentStart) {
            EmployeeConsecutiveAssignmentStart other = (EmployeeConsecutiveAssignmentStart)o;
            return new EqualsBuilder().append((Object)this.employee, (Object)other.employee).append((Object)this.shiftDate, (Object)other.shiftDate).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.employee).append((Object)this.shiftDate).toHashCode();
    }

    @Override
    public int compareTo(EmployeeConsecutiveAssignmentStart other) {
        return new CompareToBuilder().append((Object)this.employee, (Object)other.employee).append((Object)this.shiftDate, (Object)other.shiftDate).toComparison();
    }

    public String toString() {
        return this.employee + " " + this.shiftDate + " - ...";
    }

    public Contract getContract() {
        return this.employee.getContract();
    }

    public int getShiftDateDayIndex() {
        return this.shiftDate.getDayIndex();
    }

    public boolean isWeekendAndNotFirstDayOfWeekend() {
        DayOfWeek dayOfWeek;
        WeekendDefinition weekendDefinition = this.employee.getContract().getWeekendDefinition();
        return weekendDefinition.isWeekend(dayOfWeek = this.shiftDate.getDayOfWeek()) && weekendDefinition.getFirstDayOfWeekend() != dayOfWeek;
    }

    public int getDistanceToFirstDayOfWeekend() {
        WeekendDefinition weekendDefinition = this.employee.getContract().getWeekendDefinition();
        DayOfWeek dayOfWeek = this.shiftDate.getDayOfWeek();
        return weekendDefinition.getFirstDayOfWeekend().getDistanceToNext(dayOfWeek);
    }
}

