/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;
import org.optaplanner.examples.common.swingui.TangoColorFactory;
import org.optaplanner.examples.common.swingui.latitudelongitude.LatitudeLongitudeTranslator;
import org.optaplanner.examples.tsp.domain.City;
import org.optaplanner.examples.tsp.domain.Domicile;
import org.optaplanner.examples.tsp.domain.TravelingSalesmanTour;
import org.optaplanner.examples.tsp.domain.Visit;
import org.optaplanner.examples.tsp.swingui.TspPanel;

public class TspWorldPanel
extends JPanel {
    private static final int TEXT_SIZE = 12;
    private static final int CITY_NAME_TEXT_SIZE = 8;
    private static final NumberFormat NUMBER_FORMAT = new DecimalFormat("#,##0.00");
    private final TspPanel tspPanel;
    private BufferedImage canvas = null;
    private LatitudeLongitudeTranslator translator = null;
    private ImageIcon europaBackground;

    public TspWorldPanel(TspPanel tspPanel) {
        this.tspPanel = tspPanel;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TravelingSalesmanTour travelingSalesmanTour = TspWorldPanel.this.tspPanel.getTravelingSalesmanTour();
                if (travelingSalesmanTour != null) {
                    TspWorldPanel.this.resetPanel(travelingSalesmanTour);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (TspWorldPanel.this.translator != null) {
                    double longitude = TspWorldPanel.this.translator.translateXToLongitude(e.getX());
                    double latitude = TspWorldPanel.this.translator.translateYToLatitude(e.getY());
                    TspWorldPanel.this.tspPanel.insertCityAndVisit(longitude, latitude);
                }
            }
        });
        this.europaBackground = new ImageIcon(this.getClass().getResource("europaBackground.png"));
    }

    public void resetPanel(TravelingSalesmanTour travelingSalesmanTour) {
        this.translator = new LatitudeLongitudeTranslator();
        for (City city : travelingSalesmanTour.getCityList()) {
            this.translator.addCoordinates(city.getLatitude(), city.getLongitude());
        }
        Dimension size = this.getSize();
        double width = size.getWidth();
        double height = size.getHeight();
        this.translator.prepareFor(width, height);
        Graphics g = this.createCanvas(width, height);
        String tourName = travelingSalesmanTour.getName();
        if (tourName.startsWith("europe")) {
            g.drawImage(this.europaBackground.getImage(), 0, 0, this.translator.getImageWidth(), this.translator.getImageHeight(), this);
        }
        g.setFont(g.getFont().deriveFont(8.0f));
        g.setColor(TangoColorFactory.PLUM_2);
        for (Visit visit : travelingSalesmanTour.getVisitList()) {
            City city = visit.getCity();
            int x = this.translator.translateLongitudeToX(city.getLongitude());
            int y = this.translator.translateLatitudeToY(city.getLatitude());
            g.fillRect(x - 1, y - 1, 3, 3);
            if (city.getName() == null) continue;
            g.drawString(city.getName(), x + 3, y - 3);
        }
        g.setColor(TangoColorFactory.ALUMINIUM_4);
        Domicile domicile = travelingSalesmanTour.getDomicile();
        City domicileCity = domicile.getCity();
        int domicileX = this.translator.translateLongitudeToX(domicileCity.getLongitude());
        int domicileY = this.translator.translateLatitudeToY(domicileCity.getLatitude());
        g.fillRect(domicileX - 2, domicileY - 2, 5, 5);
        if (domicileCity.getName() != null) {
            g.drawString(domicileCity.getName(), domicileX + 3, domicileY - 3);
        }
        HashSet<Visit> needsBackToDomicileLineSet = new HashSet<Visit>(travelingSalesmanTour.getVisitList());
        for (Visit trailingVisit : travelingSalesmanTour.getVisitList()) {
            if (!(trailingVisit.getPreviousStandstill() instanceof Visit)) continue;
            needsBackToDomicileLineSet.remove(trailingVisit.getPreviousStandstill());
        }
        g.setColor(TangoColorFactory.CHOCOLATE_1);
        for (Visit visit : travelingSalesmanTour.getVisitList()) {
            if (visit.getPreviousStandstill() == null) continue;
            City previousCity = visit.getPreviousStandstill().getCity();
            int previousX = this.translator.translateLongitudeToX(previousCity.getLongitude());
            int previousY = this.translator.translateLatitudeToY(previousCity.getLatitude());
            City city = visit.getCity();
            int x = this.translator.translateLongitudeToX(city.getLongitude());
            int y = this.translator.translateLatitudeToY(city.getLatitude());
            g.drawLine(previousX, previousY, x, y);
            if (!needsBackToDomicileLineSet.contains(visit)) continue;
            g.drawLine(x, y, domicileX, domicileY);
        }
        g.setColor(TangoColorFactory.ALUMINIUM_4);
        g.fillRect(5, (int)height - 15 - 12, 5, 5);
        g.drawString("Domicile", 15, (int)height - 10 - 12);
        g.setColor(TangoColorFactory.PLUM_2);
        g.fillRect(6, (int)height - 9, 3, 3);
        g.drawString("Visit", 15, (int)height - 5);
        g.setColor(TangoColorFactory.ALUMINIUM_5);
        String citiesSizeString = travelingSalesmanTour.getCityList().size() + " cities";
        g.drawString(citiesSizeString, ((int)width - g.getFontMetrics().stringWidth(citiesSizeString)) / 2, (int)height - 5);
        String clickString = "Click anywhere in the map to add a visit.";
        g.drawString(clickString, (int)width - 5 - g.getFontMetrics().stringWidth(clickString), (int)height - 5);
        g.setColor(TangoColorFactory.ORANGE_3);
        SimpleLongScore score = travelingSalesmanTour.getScore();
        if (score != null) {
            double fuel = (double)(-score.getScore()) / 1000.0;
            String fuelString = NUMBER_FORMAT.format(fuel) + " fuel";
            g.setFont(g.getFont().deriveFont(1, 24.0f));
            g.drawString(fuelString, (int)width - g.getFontMetrics().stringWidth(fuelString) - 10, (int)height - 10 - 12);
        }
        this.repaint();
    }

    public void updatePanel(TravelingSalesmanTour travelingSalesmanTour) {
        this.resetPanel(travelingSalesmanTour);
    }

    private Graphics createCanvas(double width, double height) {
        int canvasWidth = (int)Math.ceil(width) + 1;
        int canvasHeight = (int)Math.ceil(height) + 1;
        this.canvas = new BufferedImage(canvasWidth, canvasHeight, 1);
        Graphics g = this.canvas.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, canvasWidth, canvasHeight);
        return g;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.canvas != null) {
            g.drawImage(this.canvas, 0, 0, this);
        }
    }
}

