/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.examples.common.domain.AbstractPersistable;

@XStreamAlias(value="VrpLocation")
public class Location
extends AbstractPersistable {
    private String name = null;
    private double latitude;
    private double longitude;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public int getDistance(Location location) {
        double latitudeDifference = location.latitude - this.latitude;
        double longitudeDifference = location.longitude - this.longitude;
        double distance = Math.sqrt(latitudeDifference * latitudeDifference + longitudeDifference * longitudeDifference);
        return (int)(distance * 1000.0 + 0.5);
    }

    public double getAngle(Location location) {
        double latitudeDifference = location.latitude - this.latitude;
        double longitudeDifference = location.longitude - this.longitude;
        return Math.atan2(latitudeDifference, longitudeDifference);
    }

    @Override
    public String toString() {
        if (this.name == null) {
            return this.id.toString();
        }
        return this.id.toString() + "-" + this.name;
    }

    public String getSafeName() {
        if (this.name == null) {
            return this.id.toString();
        }
        return this.name;
    }
}

