/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.constructionheuristic.decider.forager;

import java.util.Comparator;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.comparator.NaturalScoreComparator;
import org.optaplanner.core.config.constructionheuristic.decider.forager.ConstructionHeuristicPickEarlyType;
import org.optaplanner.core.impl.constructionheuristic.decider.forager.AbstractConstructionHeuristicForager;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicMoveScope;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicStepScope;

public class DefaultConstructionHeuristicForager
extends AbstractConstructionHeuristicForager {
    protected final ConstructionHeuristicPickEarlyType pickEarlyType;
    protected Comparator<Score> scoreComparator;
    protected ConstructionHeuristicMoveScope earlyPickedMoveScope;
    protected ConstructionHeuristicMoveScope maxScoreMoveScope;

    public DefaultConstructionHeuristicForager(ConstructionHeuristicPickEarlyType pickEarlyType) {
        this.pickEarlyType = pickEarlyType;
        this.scoreComparator = new NaturalScoreComparator();
    }

    @Override
    public void stepStarted(ConstructionHeuristicStepScope stepScope) {
        super.stepStarted(stepScope);
        this.earlyPickedMoveScope = null;
        this.maxScoreMoveScope = null;
    }

    @Override
    public void stepEnded(ConstructionHeuristicStepScope stepScope) {
        super.stepEnded(stepScope);
        this.earlyPickedMoveScope = null;
        this.maxScoreMoveScope = null;
    }

    @Override
    public void addMove(ConstructionHeuristicMoveScope moveScope) {
        this.checkPickEarly(moveScope);
        if (this.maxScoreMoveScope == null || this.scoreComparator.compare(moveScope.getScore(), this.maxScoreMoveScope.getScore()) > 0) {
            this.maxScoreMoveScope = moveScope;
        }
    }

    protected void checkPickEarly(ConstructionHeuristicMoveScope moveScope) {
        switch (this.pickEarlyType) {
            case NEVER: {
                break;
            }
            case FIRST_NON_DETERIORATING_SCORE: {
                Score lastStepScore = moveScope.getStepScope().getPhaseScope().getLastCompletedStepScope().getScore();
                if (this.scoreComparator.compare(moveScope.getScore(), lastStepScore) < 0) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            case FIRST_FEASIBLE_SCORE: {
                if (!((FeasibilityScore)moveScope.getScore()).isFeasible()) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            case FIRST_FEASIBLE_SCORE_OR_NON_DETERIORATING_HARD: {
                Score lastStepScoreDifference = moveScope.getScore().subtract(moveScope.getStepScope().getPhaseScope().getLastCompletedStepScope().getScore());
                if (!((FeasibilityScore)lastStepScoreDifference).isFeasible()) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            default: {
                throw new IllegalStateException("The pickEarlyType (" + (Object)((Object)this.pickEarlyType) + ") is not implemented.");
            }
        }
    }

    @Override
    public boolean isQuitEarly() {
        return this.earlyPickedMoveScope != null;
    }

    @Override
    public ConstructionHeuristicMoveScope pickMove(ConstructionHeuristicStepScope stepScope) {
        if (this.earlyPickedMoveScope != null) {
            return this.earlyPickedMoveScope;
        }
        return this.maxScoreMoveScope;
    }
}

