/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.valuerange.descriptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.impl.domain.common.DefaultReadMethodAccessor;
import org.optaplanner.core.impl.domain.common.ReadMethodAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.valuerange.buildin.collection.ListValueRange;
import org.optaplanner.core.impl.domain.valuerange.descriptor.AbstractValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;

public abstract class AbstractFromPropertyValueRangeDescriptor
extends AbstractValueRangeDescriptor {
    protected final ReadMethodAccessor readMethodAccessor;
    protected boolean collectionWrapping;
    protected boolean countable;

    public AbstractFromPropertyValueRangeDescriptor(GenuineVariableDescriptor variableDescriptor, boolean addNullInValueRange, Method readMethod) {
        super(variableDescriptor, addNullInValueRange);
        this.readMethodAccessor = new DefaultReadMethodAccessor(readMethod);
        ValueRangeProvider valueRangeProviderAnnotation = readMethod.getAnnotation(ValueRangeProvider.class);
        if (valueRangeProviderAnnotation == null) {
            throw new IllegalStateException("The readMethod (" + readMethod + ") must have a valueRangeProviderAnnotation (" + valueRangeProviderAnnotation + ").");
        }
        this.processValueRangeProviderAnnotation(valueRangeProviderAnnotation);
        if (addNullInValueRange && !this.countable) {
            throw new IllegalStateException("The valueRangeDescriptor (" + this + ") is nullable, but not countable (" + this.countable + ").\n" + "Maybe the readMethod (" + readMethod + ") should return " + CountableValueRange.class.getSimpleName() + ".");
        }
    }

    private void processValueRangeProviderAnnotation(ValueRangeProvider valueRangeProviderAnnotation) {
        EntityDescriptor entityDescriptor = this.variableDescriptor.getEntityDescriptor();
        Class<?> returnType = this.readMethodAccessor.getReturnType();
        this.collectionWrapping = Collection.class.isAssignableFrom(returnType);
        if (!this.collectionWrapping && !ValueRange.class.isAssignableFrom(returnType)) {
            throw new IllegalArgumentException("The entityClass (" + entityDescriptor.getEntityClass() + ") has a " + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variableDescriptor.getVariableName() + ") that refers to a " + ValueRangeProvider.class.getSimpleName() + " annotated method (" + this.readMethodAccessor.getReadMethod() + ") that does not return a " + Collection.class.getSimpleName() + " or a " + ValueRange.class.getSimpleName() + ".");
        }
        this.countable = this.collectionWrapping || CountableValueRange.class.isAssignableFrom(returnType);
    }

    @Override
    public boolean isCountable() {
        return this.countable;
    }

    protected ValueRange<?> readValueRange(Object bean) {
        ListValueRange valueRange;
        Object valueRangeObject = this.readMethodAccessor.read(bean);
        if (this.collectionWrapping) {
            List list = this.transformToList((Collection)valueRangeObject);
            valueRange = new ListValueRange(list);
        } else {
            valueRange = (ListValueRange)valueRangeObject;
        }
        return this.doNullInValueRangeWrapping(valueRange);
    }

    private <T> List<T> transformToList(Collection<T> collection) {
        return collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection);
    }
}

