/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config.statistic;

import org.optaplanner.benchmark.impl.report.ReportHelper;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.PureSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.StatisticType;
import org.optaplanner.benchmark.impl.statistic.pickedmovetypebestscore.PickedMoveTypeBestScoreDiffSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.pickedmovetypestepscore.PickedMoveTypeStepScoreDiffSingleStatistic;

public enum SingleStatisticType implements StatisticType
{
    PICKED_MOVE_TYPE_BEST_SCORE_DIFF,
    PICKED_MOVE_TYPE_STEP_SCORE_DIFF;


    public PureSingleStatistic buildPureSingleStatistic(SingleBenchmarkResult singleBenchmarkResult) {
        switch (this) {
            case PICKED_MOVE_TYPE_BEST_SCORE_DIFF: {
                return new PickedMoveTypeBestScoreDiffSingleStatistic(singleBenchmarkResult);
            }
            case PICKED_MOVE_TYPE_STEP_SCORE_DIFF: {
                return new PickedMoveTypeStepScoreDiffSingleStatistic(singleBenchmarkResult);
            }
        }
        throw new IllegalStateException("The singleStatisticType (" + this + ") is not implemented.");
    }

    public String getAnchorId() {
        return ReportHelper.escapeHtmlId(this.name());
    }

    public boolean hasScoreLevels() {
        return this == PICKED_MOVE_TYPE_BEST_SCORE_DIFF || this == PICKED_MOVE_TYPE_STEP_SCORE_DIFF;
    }
}

