/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.aggregator.swingui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.optaplanner.benchmark.impl.aggregator.swingui.MixedCheckBox;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;

public class CheckBoxTree
extends JTree {
    private static final Color TREE_SELECTION_COLOR = UIManager.getColor("Tree.selectionBackground");
    private Set<DefaultMutableTreeNode> selectedSingleBenchmarkNodes = new HashSet<DefaultMutableTreeNode>();

    public CheckBoxTree(DefaultMutableTreeNode root) {
        super(root);
        this.addMouseListener(new CheckBoxTreeMouseListener(this));
        this.setCellRenderer(new CheckBoxTreeCellRenderer());
        this.setToggleClickCount(0);
        this.getSelectionModel().setSelectionMode(1);
    }

    public Set<DefaultMutableTreeNode> getSelectedSingleBenchmarkNodes() {
        return this.selectedSingleBenchmarkNodes;
    }

    public void setSelectedSingleBenchmarkNodes(Set<DefaultMutableTreeNode> selectedSingleBenchmarkNodes) {
        this.selectedSingleBenchmarkNodes = selectedSingleBenchmarkNodes;
    }

    public void expandAllNodes() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public void collapseAllNodes() {
        for (int i = this.getRowCount() - 1; i > 0; --i) {
            this.collapseRow(i);
        }
    }

    public void updateHierarchyCheckBoxStates() {
        for (DefaultMutableTreeNode currentNode : this.selectedSingleBenchmarkNodes) {
            this.resolveNewCheckBoxState(currentNode, MixedCheckBox.MixedCheckBoxStatus.CHECKED, MixedCheckBox.MixedCheckBoxStatus.MIXED);
        }
        this.treeDidChange();
    }

    private void resolveNewCheckBoxState(DefaultMutableTreeNode currentNode, MixedCheckBox.MixedCheckBoxStatus newStatus, MixedCheckBox.MixedCheckBoxStatus mixedStatus) {
        MixedCheckBox checkBox = (MixedCheckBox)currentNode.getUserObject();
        checkBox.setStatus(newStatus);
        this.selectChildren(currentNode, newStatus);
        TreeNode[] ancestorNodes = currentNode.getPath();
        for (int i = ancestorNodes.length - 2; i >= 0; --i) {
            DefaultMutableTreeNode ancestorNode = (DefaultMutableTreeNode)ancestorNodes[i];
            MixedCheckBox ancestorCheckbox = (MixedCheckBox)ancestorNode.getUserObject();
            if (this.checkChildren(ancestorNode, newStatus)) {
                ancestorCheckbox.setStatus(newStatus);
                continue;
            }
            if (mixedStatus == null) break;
            ancestorCheckbox.setStatus(mixedStatus);
        }
    }

    private void selectChildren(DefaultMutableTreeNode parent, MixedCheckBox.MixedCheckBoxStatus status) {
        MixedCheckBox box = (MixedCheckBox)parent.getUserObject();
        if (box.getBenchmarkResult() instanceof SingleBenchmarkResult) {
            if (status == MixedCheckBox.MixedCheckBoxStatus.CHECKED) {
                this.selectedSingleBenchmarkNodes.add(parent);
            } else if (status == MixedCheckBox.MixedCheckBoxStatus.UNCHECKED) {
                this.selectedSingleBenchmarkNodes.remove(parent);
            }
        }
        Enumeration<TreeNode> children = parent.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            MixedCheckBox childCheckBox = (MixedCheckBox)child.getUserObject();
            childCheckBox.setStatus(status);
            this.selectChildren(child, status);
        }
    }

    private boolean checkChildren(DefaultMutableTreeNode parent, MixedCheckBox.MixedCheckBoxStatus status) {
        boolean childrenCheck = true;
        Enumeration<TreeNode> children = parent.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            MixedCheckBox checkBox = (MixedCheckBox)child.getUserObject();
            if (checkBox.getStatus() == status) continue;
            childrenCheck = false;
            break;
        }
        return childrenCheck;
    }

    private static class CheckBoxTreeCellRenderer
    implements TreeCellRenderer {
        private CheckBoxTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            MixedCheckBox checkBox = (MixedCheckBox)node.getUserObject();
            checkBox.setBackground(selected ? TREE_SELECTION_COLOR : Color.WHITE);
            return checkBox;
        }
    }

    private class CheckBoxTreeMouseListener
    extends MouseAdapter {
        private CheckBoxTree tree;
        private double unlabeledMixedCheckBoxWidth;

        public CheckBoxTreeMouseListener(CheckBoxTree tree) {
            this.tree = tree;
            this.unlabeledMixedCheckBoxWidth = new MixedCheckBox().getPreferredSize().getWidth();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TreePath path = this.tree.getPathForLocation(e.getX(), e.getY());
            if (path != null) {
                DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                MixedCheckBox checkBox = (MixedCheckBox)currentNode.getUserObject();
                if ((double)e.getX() - this.tree.getPathBounds(path).getX() > this.unlabeledMixedCheckBoxWidth) {
                    return;
                }
                switch (checkBox.getStatus()) {
                    case CHECKED: {
                        CheckBoxTree.this.resolveNewCheckBoxState(currentNode, MixedCheckBox.MixedCheckBoxStatus.UNCHECKED, MixedCheckBox.MixedCheckBoxStatus.MIXED);
                        break;
                    }
                    case UNCHECKED: {
                        CheckBoxTree.this.resolveNewCheckBoxState(currentNode, MixedCheckBox.MixedCheckBoxStatus.CHECKED, MixedCheckBox.MixedCheckBoxStatus.MIXED);
                        break;
                    }
                    case MIXED: {
                        CheckBoxTree.this.resolveNewCheckBoxState(currentNode, MixedCheckBox.MixedCheckBoxStatus.CHECKED, null);
                    }
                }
                this.tree.treeDidChange();
            }
        }
    }
}

