/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.solver;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.solver.XStreamXmlSolverFactory;

public abstract class SolverFactory {
    public static SolverFactory createFromXmlResource(String solverConfigResource) {
        XStreamXmlSolverFactory solverFactory = new XStreamXmlSolverFactory();
        solverFactory.configure(solverConfigResource);
        return solverFactory;
    }

    public static SolverFactory createFromXmlFile(File solverConfigFile) {
        XStreamXmlSolverFactory solverFactory = new XStreamXmlSolverFactory();
        solverFactory.configure(solverConfigFile);
        return solverFactory;
    }

    public static SolverFactory createFromXmlInputStream(InputStream in) {
        XStreamXmlSolverFactory solverFactory = new XStreamXmlSolverFactory();
        solverFactory.configure(in);
        return solverFactory;
    }

    public static SolverFactory createFromXmlReader(Reader reader) {
        XStreamXmlSolverFactory solverFactory = new XStreamXmlSolverFactory();
        solverFactory.configure(reader);
        return solverFactory;
    }

    public abstract SolverConfig getSolverConfig();

    public abstract Solver buildSolver();
}

