/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.phase;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamInclude;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import org.optaplanner.core.config.exhaustivesearch.ExhaustiveSearchPhaseConfig;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.localsearch.LocalSearchPhaseConfig;
import org.optaplanner.core.config.phase.custom.CustomPhaseConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.phase.AbstractPhase;
import org.optaplanner.core.impl.phase.Phase;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.termination.PhaseToSolverTerminationBridge;
import org.optaplanner.core.impl.solver.termination.Termination;

@XStreamInclude(value={CustomPhaseConfig.class, ExhaustiveSearchPhaseConfig.class, ConstructionHeuristicPhaseConfig.class, LocalSearchPhaseConfig.class})
public abstract class PhaseConfig {
    @XStreamAlias(value="termination")
    private TerminationConfig terminationConfig = null;

    public TerminationConfig getTerminationConfig() {
        return this.terminationConfig;
    }

    public void setTerminationConfig(TerminationConfig terminationConfig) {
        this.terminationConfig = terminationConfig;
    }

    public abstract Phase buildPhase(int var1, HeuristicConfigPolicy var2, BestSolutionRecaller var3, Termination var4);

    protected void configurePhase(AbstractPhase phase, int phaseIndex, HeuristicConfigPolicy configPolicy, BestSolutionRecaller bestSolutionRecaller, Termination solverTermination) {
        phase.setPhaseIndex(phaseIndex);
        phase.setBestSolutionRecaller(bestSolutionRecaller);
        TerminationConfig terminationConfig_ = this.terminationConfig == null ? new TerminationConfig() : this.terminationConfig;
        phase.setTermination(terminationConfig_.buildTermination(configPolicy, new PhaseToSolverTerminationBridge(solverTermination)));
    }

    public void inherit(PhaseConfig inheritedConfig) {
        if (this.terminationConfig == null) {
            this.terminationConfig = inheritedConfig.getTerminationConfig();
        } else if (inheritedConfig.getTerminationConfig() != null) {
            this.terminationConfig.inherit(inheritedConfig.getTerminationConfig());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

