/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.descriptor;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.lang.ArrayUtils;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableGraphType;
import org.optaplanner.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.valuerange.descriptor.CompositeValueRangeDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.FromEntityPropertyValueRangeDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.FromSolutionPropertyValueRangeDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.entity.decorator.NullValueReinitializeVariableEntityFilter;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class GenuineVariableDescriptor
extends VariableDescriptor {
    private boolean chained;
    private ValueRangeDescriptor valueRangeDescriptor;
    private boolean nullable;
    private SelectionFilter reinitializeVariableEntityFilter;
    private SelectionSorter increasingStrengthSorter;
    private SelectionSorter decreasingStrengthSorter;

    public GenuineVariableDescriptor(EntityDescriptor entityDescriptor, PropertyDescriptor propertyDescriptor) {
        super(entityDescriptor, propertyDescriptor);
    }

    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        this.processPropertyAnnotations(descriptorPolicy);
    }

    private void processPropertyAnnotations(DescriptorPolicy descriptorPolicy) {
        PlanningVariable planningVariableAnnotation = this.variablePropertyAccessor.getReadMethod().getAnnotation(PlanningVariable.class);
        this.processNullable(descriptorPolicy, planningVariableAnnotation);
        this.processChained(descriptorPolicy, planningVariableAnnotation);
        this.processValueRangeRefs(descriptorPolicy, planningVariableAnnotation);
        this.processStrength(descriptorPolicy, planningVariableAnnotation);
    }

    private void processNullable(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        this.nullable = planningVariableAnnotation.nullable();
        if (this.nullable && this.variablePropertyAccessor.getPropertyType().isPrimitive()) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") with nullable (" + this.nullable + "), which is not compatible with the primitive propertyType (" + this.variablePropertyAccessor.getPropertyType() + ").");
        }
        Class<? extends SelectionFilter> reinitializeVariableEntityFilterClass = planningVariableAnnotation.reinitializeVariableEntityFilter();
        if (reinitializeVariableEntityFilterClass == PlanningVariable.NullReinitializeVariableEntityFilter.class) {
            reinitializeVariableEntityFilterClass = null;
        }
        this.reinitializeVariableEntityFilter = reinitializeVariableEntityFilterClass != null ? ConfigUtils.newInstance(this, "reinitializeVariableEntityFilterClass", reinitializeVariableEntityFilterClass) : new NullValueReinitializeVariableEntityFilter(this);
    }

    private void processChained(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        boolean bl = this.chained = planningVariableAnnotation.graphType() == PlanningVariableGraphType.CHAINED;
        if (this.chained && !this.variablePropertyAccessor.getPropertyType().isAssignableFrom(this.entityDescriptor.getEntityClass())) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") with chained (" + this.chained + ") and propertyType (" + this.variablePropertyAccessor.getPropertyType() + ") which is not a superclass/interface of or the same as the entityClass (" + this.entityDescriptor.getEntityClass() + ").");
        }
        if (this.chained && this.nullable) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") with chained (" + this.chained + "), which is not compatible with nullable (" + this.nullable + ").");
        }
    }

    private void processValueRangeRefs(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        Object[] valueRangeProviderRefs = planningVariableAnnotation.valueRangeProviderRefs();
        if (ArrayUtils.isEmpty((Object[])valueRangeProviderRefs)) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variablePropertyAccessor.getName() + ") that has no valueRangeProviderRefs (" + Arrays.toString(valueRangeProviderRefs) + ").");
        }
        ArrayList<ValueRangeDescriptor> valueRangeDescriptorList = new ArrayList<ValueRangeDescriptor>(valueRangeProviderRefs.length);
        boolean addNullInValueRange = this.nullable && valueRangeProviderRefs.length == 1;
        for (Object valueRangeProviderRef : valueRangeProviderRefs) {
            valueRangeDescriptorList.add(this.buildValueRangeDescriptor(descriptorPolicy, (String)valueRangeProviderRef, addNullInValueRange));
        }
        this.valueRangeDescriptor = valueRangeDescriptorList.size() == 1 ? (ValueRangeDescriptor)valueRangeDescriptorList.get(0) : new CompositeValueRangeDescriptor(this, this.nullable, valueRangeDescriptorList);
    }

    private ValueRangeDescriptor buildValueRangeDescriptor(DescriptorPolicy descriptorPolicy, String valueRangeProviderRef, boolean addNullInValueRange) {
        if (descriptorPolicy.hasFromSolutionValueRangeProvider(valueRangeProviderRef)) {
            Method readMethod = descriptorPolicy.getFromSolutionValueRangeProvider(valueRangeProviderRef);
            return new FromSolutionPropertyValueRangeDescriptor(this, addNullInValueRange, readMethod);
        }
        if (descriptorPolicy.hasFromEntityValueRangeProvider(valueRangeProviderRef)) {
            Method readMethod = descriptorPolicy.getFromEntityValueRangeProvider(valueRangeProviderRef);
            return new FromEntityPropertyValueRangeDescriptor(this, addNullInValueRange, readMethod);
        }
        throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + PlanningVariable.class.getSimpleName() + ") annotated property (" + this.variablePropertyAccessor.getName() + ") with a valueRangeProviderRef (" + valueRangeProviderRef + ") that does not exist on a registered " + PlanningSolution.class.getSimpleName() + " or " + PlanningEntity.class.getSimpleName() + ".\n" + "The valueRangeProviderRef (" + valueRangeProviderRef + ") does not appear in valueRangeProvideIds (" + descriptorPolicy.getValueRangeProviderIds() + ").");
    }

    private void processStrength(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        Class<? extends SelectionSorterWeightFactory> strengthWeightFactoryClass;
        Class<? extends Comparator> strengthComparatorClass = planningVariableAnnotation.strengthComparatorClass();
        if (strengthComparatorClass == PlanningVariable.NullStrengthComparator.class) {
            strengthComparatorClass = null;
        }
        if ((strengthWeightFactoryClass = planningVariableAnnotation.strengthWeightFactoryClass()) == PlanningVariable.NullStrengthWeightFactory.class) {
            strengthWeightFactoryClass = null;
        }
        if (strengthComparatorClass != null && strengthWeightFactoryClass != null) {
            throw new IllegalStateException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") property (" + this.variablePropertyAccessor.getName() + ") cannot have a strengthComparatorClass (" + strengthComparatorClass.getName() + ") and a strengthWeightFactoryClass (" + strengthWeightFactoryClass.getName() + ") at the same time.");
        }
        if (strengthComparatorClass != null) {
            Comparator strengthComparator = ConfigUtils.newInstance(this, "strengthComparatorClass", strengthComparatorClass);
            this.increasingStrengthSorter = new ComparatorSelectionSorter(strengthComparator, SelectionSorterOrder.ASCENDING);
            this.decreasingStrengthSorter = new ComparatorSelectionSorter(strengthComparator, SelectionSorterOrder.DESCENDING);
        }
        if (strengthWeightFactoryClass != null) {
            SelectionSorterWeightFactory strengthWeightFactory = ConfigUtils.newInstance(this, "strengthWeightFactoryClass", strengthWeightFactoryClass);
            this.increasingStrengthSorter = new WeightFactorySelectionSorter(strengthWeightFactory, SelectionSorterOrder.ASCENDING);
            this.decreasingStrengthSorter = new WeightFactorySelectionSorter(strengthWeightFactory, SelectionSorterOrder.DESCENDING);
        }
    }

    public boolean isChained() {
        return this.chained;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public SelectionFilter getReinitializeVariableEntityFilter() {
        return this.reinitializeVariableEntityFilter;
    }

    public ValueRangeDescriptor getValueRangeDescriptor() {
        return this.valueRangeDescriptor;
    }

    public boolean isValueRangeEntityIndependent() {
        return this.valueRangeDescriptor.isEntityIndependent();
    }

    public boolean isInitialized(Object entity) {
        if (this.nullable) {
            return true;
        }
        Object variable = this.getValue(entity);
        return variable != null;
    }

    public boolean isReinitializable(ScoreDirector scoreDirector, Object entity) {
        return this.reinitializeVariableEntityFilter.accept(scoreDirector, entity);
    }

    public SelectionSorter getIncreasingStrengthSorter() {
        return this.increasingStrengthSorter;
    }

    public SelectionSorter getDecreasingStrengthSorter() {
        return this.decreasingStrengthSorter;
    }

    public long getValueCount(Solution solution, Object entity) {
        if (!this.valueRangeDescriptor.isCountable()) {
            return 0L;
        }
        return ((CountableValueRange)this.valueRangeDescriptor.extractValueRange(solution, entity)).getSize();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.variablePropertyAccessor.getName() + " of " + this.entityDescriptor.getEntityClass().getName() + ")";
    }
}

