/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.phase.scope;

import java.util.Random;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public abstract class AbstractStepScope {
    protected final int stepIndex;
    protected Score score = null;
    protected Boolean bestScoreImproved;
    protected Solution clonedSolution = null;

    public abstract AbstractPhaseScope getPhaseScope();

    public AbstractStepScope(int stepIndex) {
        this.stepIndex = stepIndex;
    }

    public int getStepIndex() {
        return this.stepIndex;
    }

    public abstract int getUninitializedVariableCount();

    public boolean hasNoUninitializedVariables() {
        return this.getUninitializedVariableCount() == 0;
    }

    public Score getScore() {
        return this.score;
    }

    public void setScore(Score score) {
        this.score = score;
    }

    public Boolean getBestScoreImproved() {
        return this.bestScoreImproved;
    }

    public void setBestScoreImproved(Boolean bestScoreImproved) {
        this.bestScoreImproved = bestScoreImproved;
    }

    public Solution getClonedSolution() {
        return this.clonedSolution;
    }

    public void setClonedSolution(Solution clonedSolution) {
        this.clonedSolution = clonedSolution;
    }

    public InnerScoreDirector getScoreDirector() {
        return this.getPhaseScope().getScoreDirector();
    }

    public Solution getWorkingSolution() {
        return this.getPhaseScope().getWorkingSolution();
    }

    public Random getWorkingRandom() {
        return this.getPhaseScope().getWorkingRandom();
    }

    public Solution createOrGetClonedSolution() {
        if (this.clonedSolution == null) {
            this.clonedSolution = this.getScoreDirector().cloneWorkingSolution();
        }
        return this.clonedSolution;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.stepIndex + ")";
    }
}

