/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.aggregator.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class SwingUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    public static void register() {
        SwingUncaughtExceptionHandler exceptionHandler = new SwingUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(exceptionHandler);
        System.setProperty("sun.awt.exception.handler", SwingUncaughtExceptionHandler.class.getName());
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        System.err.append("Exception in thread \"").append(t.getName()).append("\" ");
        e.printStackTrace();
        this.displayException(t, e);
    }

    private void displayException(Thread t, Throwable e) {
        final JFrame exceptionFrame = new JFrame("Uncaught exception: " + e.getMessage());
        Icon errorIcon = UIManager.getIcon("OptionPane.errorIcon");
        BufferedImage errorImage = new BufferedImage(errorIcon.getIconWidth(), errorIcon.getIconHeight(), 1);
        errorIcon.paintIcon(null, errorImage.getGraphics(), 0, 0);
        exceptionFrame.setIconImage(errorImage);
        exceptionFrame.setDefaultCloseOperation(2);
        JPanel contentPanel = new JPanel(new BorderLayout(5, 5));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPanel.add((Component)new JLabel("An uncaught exception has occurred: "), "North");
        JTextArea stackTraceTextArea = new JTextArea(30, 80);
        stackTraceTextArea.setEditable(false);
        stackTraceTextArea.append("Exception in thread \"" + t.getName() + "\" " + e.getClass().getName() + ": " + e.getMessage() + "\n");
        for (StackTraceElement stackTraceElement : e.getStackTrace()) {
            stackTraceTextArea.append("    at " + stackTraceElement.toString() + "\n");
        }
        Throwable parentException = e;
        for (Throwable cause = e.getCause(); cause != null && cause != parentException; cause = cause.getCause()) {
            stackTraceTextArea.append("Caused by: \" " + cause.getClass().getName() + ": " + cause.getMessage() + "\n");
            for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                stackTraceTextArea.append("    at " + stackTraceElement.toString() + "\n");
            }
            parentException = cause;
        }
        JScrollPane stackTraceScrollPane = new JScrollPane(stackTraceTextArea, 22, 30);
        contentPanel.add((Component)stackTraceScrollPane, "Center");
        stackTraceTextArea.setCaretPosition(0);
        JButton closeButton = new JButton(new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                exceptionFrame.setVisible(false);
                exceptionFrame.dispose();
            }
        });
        contentPanel.add((Component)closeButton, "South");
        exceptionFrame.setContentPane(contentPanel);
        exceptionFrame.pack();
        exceptionFrame.setLocationRelativeTo(null);
        exceptionFrame.setVisible(true);
    }
}

