/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.ranking;

import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.benchmark.impl.ranking.SolverRankingWeightFactory;
import org.optaplanner.benchmark.impl.ranking.TotalScoreSolverRankingComparator;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.core.api.score.Score;

public class TotalRankSolverRankingWeightFactory
implements SolverRankingWeightFactory {
    @Override
    public Comparable createRankingWeight(List<SolverBenchmarkResult> solverBenchmarkResultList, SolverBenchmarkResult solverBenchmarkResult) {
        int betterCount = 0;
        int equalCount = 0;
        List<Score> scoreList = solverBenchmarkResult.getScoreList();
        for (SolverBenchmarkResult otherSolverBenchmarkResult : solverBenchmarkResultList) {
            if (otherSolverBenchmarkResult == solverBenchmarkResult) continue;
            List<Score> otherScoreList = otherSolverBenchmarkResult.getScoreList();
            for (int i = 0; i < scoreList.size(); ++i) {
                Score otherScore;
                Score score = scoreList.get(i);
                int scoreComparison = score.compareTo((Object)(otherScore = otherScoreList.get(i)));
                if (scoreComparison > 0) {
                    ++betterCount;
                    continue;
                }
                if (scoreComparison != 0) continue;
                ++equalCount;
            }
        }
        return new TotalRankSolverRankingWeight(solverBenchmarkResult, betterCount, equalCount);
    }

    public static class TotalRankSolverRankingWeight
    implements Comparable<TotalRankSolverRankingWeight> {
        private final Comparator<SolverBenchmarkResult> totalScoreSolverRankingComparator = new TotalScoreSolverRankingComparator();
        private SolverBenchmarkResult solverBenchmarkResult;
        private int betterCount;
        private int equalCount;

        public TotalRankSolverRankingWeight(SolverBenchmarkResult solverBenchmarkResult, int betterCount, int equalCount) {
            this.solverBenchmarkResult = solverBenchmarkResult;
            this.betterCount = betterCount;
            this.equalCount = equalCount;
        }

        @Override
        public int compareTo(TotalRankSolverRankingWeight other) {
            return new CompareToBuilder().append(this.betterCount, other.betterCount).append(this.equalCount, other.equalCount).append((Object)this.solverBenchmarkResult, (Object)other.solverBenchmarkResult, this.totalScoreSolverRankingComparator).toComparison();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof TotalRankSolverRankingWeight) {
                TotalRankSolverRankingWeight other = (TotalRankSolverRankingWeight)o;
                return new EqualsBuilder().append(this.betterCount, other.betterCount).append(this.equalCount, other.equalCount).appendSuper(this.totalScoreSolverRankingComparator.compare(this.solverBenchmarkResult, other.solverBenchmarkResult) == 0).isEquals();
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.betterCount).append(this.equalCount).toHashCode();
        }
    }
}

