/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.solver.score;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.score.director.incremental.AbstractIncrementalScoreCalculator;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Standstill;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedVehicleRoutingSolution;

public class VehicleRoutingIncrementalScoreCalculator
extends AbstractIncrementalScoreCalculator<VehicleRoutingSolution> {
    private boolean timeWindowed;
    private Map<Vehicle, Integer> vehicleDemandMap;
    private int hardScore;
    private int softScore;

    @Override
    public void resetWorkingSolution(VehicleRoutingSolution solution) {
        this.timeWindowed = solution instanceof TimeWindowedVehicleRoutingSolution;
        List<Vehicle> vehicleList = solution.getVehicleList();
        this.vehicleDemandMap = new HashMap<Vehicle, Integer>(vehicleList.size());
        for (Vehicle vehicle : vehicleList) {
            this.vehicleDemandMap.put(vehicle, 0);
        }
        this.hardScore = 0;
        this.softScore = 0;
        for (Customer customer : solution.getCustomerList()) {
            this.insertPreviousStandstill(customer);
            this.insertVehicle(customer);
            if (!this.timeWindowed) continue;
            this.insertArrivalTime((TimeWindowedCustomer)customer);
        }
    }

    @Override
    public void beforeEntityAdded(Object entity) {
    }

    @Override
    public void afterEntityAdded(Object entity) {
        if (entity instanceof Vehicle) {
            return;
        }
        this.insertPreviousStandstill((Customer)entity);
        this.insertVehicle((Customer)entity);
        if (this.timeWindowed) {
            this.insertArrivalTime((TimeWindowedCustomer)entity);
        }
    }

    @Override
    public void beforeVariableChanged(Object entity, String variableName) {
        if (entity instanceof Vehicle) {
            return;
        }
        if (variableName.equals("previousStandstill")) {
            this.retractPreviousStandstill((Customer)entity);
        } else if (variableName.equals("vehicle")) {
            this.retractVehicle((Customer)entity);
        } else if (variableName.equals("nextCustomer")) {
            this.retractNextCustomer((Customer)entity);
        } else if (variableName.equals("arrivalTime")) {
            this.retractArrivalTime((TimeWindowedCustomer)entity);
        } else {
            throw new IllegalArgumentException("Unsupported variableName (" + variableName + ").");
        }
    }

    @Override
    public void afterVariableChanged(Object entity, String variableName) {
        if (entity instanceof Vehicle) {
            return;
        }
        if (variableName.equals("previousStandstill")) {
            this.insertPreviousStandstill((Customer)entity);
        } else if (variableName.equals("vehicle")) {
            this.insertVehicle((Customer)entity);
        } else if (variableName.equals("nextCustomer")) {
            this.insertNextCustomer((Customer)entity);
        } else if (variableName.equals("arrivalTime")) {
            this.insertArrivalTime((TimeWindowedCustomer)entity);
        } else {
            throw new IllegalArgumentException("Unsupported variableName (" + variableName + ").");
        }
    }

    @Override
    public void beforeEntityRemoved(Object entity) {
        if (entity instanceof Vehicle) {
            return;
        }
        this.retractPreviousStandstill((Customer)entity);
        this.retractVehicle((Customer)entity);
        if (this.timeWindowed) {
            this.retractArrivalTime((TimeWindowedCustomer)entity);
        }
    }

    @Override
    public void afterEntityRemoved(Object entity) {
    }

    private void insertPreviousStandstill(Customer customer) {
        Standstill previousStandstill = customer.getPreviousStandstill();
        if (previousStandstill != null) {
            this.softScore -= customer.getDistanceFromPreviousStandstill();
        }
    }

    private void retractPreviousStandstill(Customer customer) {
        Standstill previousStandstill = customer.getPreviousStandstill();
        if (previousStandstill != null) {
            this.softScore += customer.getDistanceFromPreviousStandstill();
        }
    }

    private void insertVehicle(Customer customer) {
        Vehicle vehicle = customer.getVehicle();
        if (vehicle != null) {
            int capacity = vehicle.getCapacity();
            int oldDemand = this.vehicleDemandMap.get(vehicle);
            int newDemand = oldDemand + customer.getDemand();
            this.hardScore += Math.min(capacity - newDemand, 0) - Math.min(capacity - oldDemand, 0);
            this.vehicleDemandMap.put(vehicle, newDemand);
            if (customer.getNextCustomer() == null) {
                this.softScore -= customer.getLocation().getDistance(vehicle.getLocation());
            }
        }
    }

    private void retractVehicle(Customer customer) {
        Vehicle vehicle = customer.getVehicle();
        if (vehicle != null) {
            int capacity = vehicle.getCapacity();
            int oldDemand = this.vehicleDemandMap.get(vehicle);
            int newDemand = oldDemand - customer.getDemand();
            this.hardScore += Math.min(capacity - newDemand, 0) - Math.min(capacity - oldDemand, 0);
            this.vehicleDemandMap.put(vehicle, newDemand);
            if (customer.getNextCustomer() == null) {
                this.softScore += customer.getLocation().getDistance(vehicle.getLocation());
            }
        }
    }

    private void insertNextCustomer(Customer customer) {
        Vehicle vehicle = customer.getVehicle();
        if (vehicle != null && customer.getNextCustomer() == null) {
            this.softScore -= customer.getLocation().getDistance(vehicle.getLocation());
        }
    }

    private void retractNextCustomer(Customer customer) {
        Vehicle vehicle = customer.getVehicle();
        if (vehicle != null && customer.getNextCustomer() == null) {
            this.softScore += customer.getLocation().getDistance(vehicle.getLocation());
        }
    }

    private void insertArrivalTime(TimeWindowedCustomer customer) {
        int dueTime;
        Integer arrivalTime = customer.getArrivalTime();
        if (arrivalTime != null && (dueTime = customer.getDueTime()) < arrivalTime) {
            this.hardScore -= arrivalTime - dueTime;
        }
    }

    private void retractArrivalTime(TimeWindowedCustomer customer) {
        int dueTime;
        Integer arrivalTime = customer.getArrivalTime();
        if (arrivalTime != null && (dueTime = customer.getDueTime()) < arrivalTime) {
            this.hardScore += arrivalTime - dueTime;
        }
    }

    @Override
    public HardSoftScore calculateScore() {
        return HardSoftScore.valueOf(this.hardScore, this.softScore);
    }
}

