/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.beliefsystem.simple.SimpleMode;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.EqualityKeyComparator;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.ObjectHashMap;
import org.kie.internal.runtime.beliefs.Mode;

public class TruthMaintenanceSystem {
    private StatefulKnowledgeSessionImpl wm;
    private ObjectHashMap equalityKeyMap;
    private BeliefSystem defaultBeliefSystem;

    public TruthMaintenanceSystem() {
    }

    public TruthMaintenanceSystem(StatefulKnowledgeSessionImpl wm, NamedEntryPoint ep) {
        this.wm = wm;
        this.equalityKeyMap = new ObjectHashMap();
        this.equalityKeyMap.setComparator(EqualityKeyComparator.getInstance());
        this.defaultBeliefSystem = wm.getKnowledgeBase().getConfiguration().getComponentFactory().getBeliefSystemFactory().createBeliefSystem(wm.getSessionConfiguration().getBeliefSystemType(), ep, this);
    }

    public ObjectHashMap getEqualityKeyMap() {
        return this.equalityKeyMap;
    }

    public Object put(EqualityKey key) {
        return this.equalityKeyMap.put(key, key, false);
    }

    public EqualityKey get(EqualityKey key) {
        return (EqualityKey)this.equalityKeyMap.get(key);
    }

    public EqualityKey get(Object object) {
        return (EqualityKey)this.equalityKeyMap.get(object);
    }

    public EqualityKey remove(EqualityKey key) {
        return (EqualityKey)this.equalityKeyMap.remove(key);
    }

    public void readLogicalDependency(InternalFactHandle handle, Object object, Object value, Activation activation, PropagationContext context, RuleImpl rule, ObjectTypeConf typeConf) {
        this.addLogicalDependency(handle, object, value, activation, context, rule, typeConf, true);
    }

    public void addLogicalDependency(InternalFactHandle handle, Object object, Object value, Activation activation, PropagationContext context, RuleImpl rule, ObjectTypeConf typeConf) {
        this.addLogicalDependency(handle, object, value, activation, context, rule, typeConf, false);
    }

    public void addLogicalDependency(InternalFactHandle handle, Object object, Object value, Activation activation, PropagationContext context, RuleImpl rule, ObjectTypeConf typeConf, boolean read) {
        BeliefSet beliefSet;
        BeliefSystem beliefSystem = this.defaultBeliefSystem;
        if (value != null && value instanceof Mode & !(value instanceof SimpleMode)) {
            Mode mode = (Mode)value;
            beliefSystem = (BeliefSystem)mode.getBeliefSystem();
        }
        if ((beliefSet = handle.getEqualityKey().getBeliefSet()) == null) {
            if (context.getType() == 2) {
                // empty if block
            }
            beliefSet = beliefSystem.newBeliefSet(handle);
            handle.getEqualityKey().setBeliefSet(beliefSet);
        }
        LogicalDependency node = beliefSystem.newLogicalDependency(activation, beliefSet, object, value);
        activation.getRule().setHasLogicalDependency(true);
        activation.addLogicalDependency(node);
        if (read) {
            beliefSystem.read(node, beliefSet, context, typeConf);
        } else {
            beliefSystem.insert(node, beliefSet, context, typeConf);
        }
    }

    public void clear() {
        this.equalityKeyMap.clear();
    }

    public BeliefSystem getBeliefSystem() {
        return this.defaultBeliefSystem;
    }
}

