/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleSink;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Behavior;
import org.drools.core.rule.BehaviorManager;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.SlidingTimeWindow;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.Iterator;
import org.drools.core.util.ObjectHashSet;
import org.drools.core.util.bitmask.BitMask;

public class WindowNode
extends ObjectSource
implements ObjectSinkNode,
RightTupleSink,
MemoryFactory {
    private static final long serialVersionUID = 540L;
    private List<AlphaNodeFieldConstraint> constraints;
    protected BehaviorManager behavior;
    private EntryPointId entryPoint;
    private ObjectSinkNode previousRightTupleSinkNode;
    private ObjectSinkNode nextRightTupleSinkNode;
    protected EntryPointNode epNode;
    private transient ObjectTypeNode.Id rightInputOtnId = ObjectTypeNode.DEFAULT_ID;

    public WindowNode() {
    }

    public WindowNode(int id, List<AlphaNodeFieldConstraint> constraints, List<Behavior> behaviors, ObjectSource objectSource, BuildContext context) {
        super(id, context.getPartitionId(), context.getKnowledgeBase().getConfiguration().isMultithreadEvaluation(), objectSource, context.getKnowledgeBase().getConfiguration().getAlphaNodeHashingThreshold());
        this.constraints = new ArrayList<AlphaNodeFieldConstraint>(constraints);
        this.behavior = new BehaviorManager(behaviors);
        this.entryPoint = context.getCurrentEntryPoint();
        for (Behavior b : behaviors) {
            if (!(b instanceof SlidingTimeWindow)) continue;
            ((SlidingTimeWindow)b).setWindowNode(this);
        }
        this.epNode = (EntryPointNode)this.getObjectTypeNode().getParentObjectSource();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.constraints = (List)in.readObject();
        this.behavior = (BehaviorManager)in.readObject();
        this.entryPoint = (EntryPointId)in.readObject();
        this.epNode = (EntryPointNode)this.getObjectTypeNode().getParentObjectSource();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.constraints);
        out.writeObject(this.behavior);
        out.writeObject(this.entryPoint);
        this.epNode = (EntryPointNode)this.getObjectTypeNode().getParentObjectSource();
    }

    @Override
    public short getType() {
        return 60;
    }

    @Override
    public void assertRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    public List<AlphaNodeFieldConstraint> getConstraints() {
        return this.constraints;
    }

    public Behavior[] getBehaviors() {
        return this.behavior.getBehaviors();
    }

    @Override
    public void attach(BuildContext context) {
        this.source.addObjectSink(this);
        if (context == null || context.getKnowledgeBase().getConfiguration().isPhreakEnabled()) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextFactory pctxFactory = workingMemory.getKnowledgeBase().getConfiguration().getComponentFactory().getPropagationContextFactory();
            PropagationContext propagationContext = pctxFactory.createPropagationContext(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.source.updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        WindowMemory memory = (WindowMemory)workingMemory.getNodeMemory(this);
        EventFactHandle evFh = (EventFactHandle)factHandle;
        int index = 0;
        for (AlphaNodeFieldConstraint constraint : this.constraints) {
            if (constraint.isAllowed(evFh, workingMemory, memory.context[index++])) continue;
            return;
        }
        RightTuple rightTuple = new RightTuple(evFh, this);
        rightTuple.setPropagationContext(pctx);
        EventFactHandle clonedFh = evFh.cloneAndLink();
        rightTuple.setObject(clonedFh);
        if (!this.behavior.assertFact(memory.behaviorContext, clonedFh, pctx, workingMemory)) {
            return;
        }
        this.sink.propagateAssertObject(clonedFh, pctx, workingMemory);
    }

    @Override
    public void retractRightTuple(RightTuple rightTuple, PropagationContext pctx, InternalWorkingMemory wm) {
        WindowMemory memory = (WindowMemory)wm.getNodeMemory(this);
        this.behavior.retractFact(memory.behaviorContext, rightTuple.getFactHandle(), pctx, wm);
        InternalFactHandle clonedFh = (InternalFactHandle)rightTuple.getObject();
        ObjectTypeNode.doRetractObject(clonedFh, pctx, wm);
    }

    @Override
    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        WindowMemory memory = (WindowMemory)workingMemory.getNodeMemory(this);
        EventFactHandle originalFactHandle = (EventFactHandle)rightTuple.getFactHandle();
        EventFactHandle cloneFactHandle = (EventFactHandle)rightTuple.getObject();
        originalFactHandle.quickCloneUpdate(cloneFactHandle);
        int index = 0;
        boolean isAllowed = true;
        for (AlphaNodeFieldConstraint constraint : this.constraints) {
            if (constraint.isAllowed(cloneFactHandle, workingMemory, memory.context[index++])) continue;
            isAllowed = false;
            break;
        }
        if (isAllowed) {
            ModifyPreviousTuples modifyPreviousTuples = new ModifyPreviousTuples(cloneFactHandle.getFirstLeftTuple(), cloneFactHandle.getFirstRightTuple(), this.epNode);
            cloneFactHandle.clearLeftTuples();
            cloneFactHandle.clearRightTuples();
            this.sink.propagateModifyObject(cloneFactHandle, modifyPreviousTuples, context, workingMemory);
            modifyPreviousTuples.retractTuples(context, workingMemory);
        } else {
            ObjectTypeNode.doRetractObject(cloneFactHandle, context, workingMemory);
        }
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory wm) {
        RightTuple rightTuple = modifyPreviousTuples.peekRightTuple();
        while (rightTuple != null && rightTuple.getRightTupleSink().getRightInputOtnId().before(this.getRightInputOtnId())) {
            modifyPreviousTuples.removeRightTuple();
            rightTuple.setPropagationContext(context);
            rightTuple.getRightTupleSink().retractRightTuple(rightTuple, context, wm);
            rightTuple = modifyPreviousTuples.peekRightTuple();
        }
        if (rightTuple != null && rightTuple.getRightTupleSink().getRightInputOtnId().equals(this.getRightInputOtnId())) {
            modifyPreviousTuples.removeRightTuple();
            rightTuple.reAdd();
            this.modifyRightTuple(rightTuple, context, wm);
        } else {
            this.assertObject(factHandle, context, wm);
        }
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        WindowMemory memory = (WindowMemory)workingMemory.getNodeMemory(this);
        this.sink.byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory wm) {
        WindowMemory memory = (WindowMemory)wm.getNodeMemory(this);
        ObjectTypeNode.ObjectTypeNodeMemory omem = (ObjectTypeNode.ObjectTypeNodeMemory)wm.getNodeMemory(this.getObjectTypeNode());
        Iterator it = omem.getObjectHashSet().iterator();
        ObjectHashSet.ObjectEntry entry = (ObjectHashSet.ObjectEntry)it.next();
        while (entry != null) {
            InternalFactHandle fh = (InternalFactHandle)entry.getValue();
            sink.assertObject(fh, context, wm);
            entry = (ObjectHashSet.ObjectEntry)it.next();
        }
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        WindowMemory memory = new WindowMemory();
        memory.context = new ContextEntry[this.constraints.size()];
        int index = 0;
        for (AlphaNodeFieldConstraint alpha : this.constraints) {
            memory.context[index++] = alpha.createContextEntry();
        }
        memory.behaviorContext = this.behavior.createBehaviorContext();
        return memory;
    }

    @Override
    public String toString() {
        return "[WindowNode(" + this.id + ") constraints=" + this.constraints + "]";
    }

    @Override
    public int hashCode() {
        return this.source.hashCode() * 17 + (this.constraints != null ? ((Object)this.constraints).hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof WindowNode)) {
            return false;
        }
        WindowNode other = (WindowNode)object;
        return this.source.equals(other.source) && ((Object)this.constraints).equals(other.constraints) && this.behavior.equals(other.behavior);
    }

    @Override
    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextRightTupleSinkNode;
    }

    @Override
    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextRightTupleSinkNode = next;
    }

    @Override
    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousRightTupleSinkNode;
    }

    @Override
    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousRightTupleSinkNode = previous;
    }

    public EntryPointId getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public BitMask calculateDeclaredMask(List<String> settableProperties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectTypeNode.Id getRightInputOtnId() {
        return this.rightInputOtnId;
    }

    public void setRightInputOtnId(ObjectTypeNode.Id rightInputOtnId) {
        this.rightInputOtnId = rightInputOtnId;
    }

    public static class WindowMemory
    implements Memory {
        public ContextEntry[] context;
        public Object behaviorContext;

        @Override
        public short getNodeType() {
            return 60;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return null;
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentMemory) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Memory getPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPrevious(Memory previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Memory getNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNext(Memory next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void nullPrevNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
        }
    }
}

