/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.builder;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.mvel.ActivationPropertyHandler;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.common.AgendaItemImpl;
import org.drools.core.common.InstanceNotEqualsConstraint;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.builder.BuildUtils;
import org.drools.core.reteoo.builder.NodeFactory;
import org.drools.core.reteoo.builder.ReteooComponentBuilder;
import org.drools.core.rule.Behavior;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.IntervalProviderConstraint;
import org.drools.core.rule.InvalidPatternException;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.PatternSource;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.rule.WindowReference;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.BetaNodeFieldConstraint;
import org.drools.core.spi.Constraint;
import org.drools.core.spi.ObjectType;
import org.drools.core.time.impl.CompositeMaxDurationTimer;
import org.drools.core.time.impl.DurationTimer;
import org.drools.core.time.impl.Timer;
import org.kie.api.conf.EventProcessingOption;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.PropertyHandlerFactory;

public class PatternBuilder
implements ReteooComponentBuilder {
    @Override
    public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
        Pattern pattern = (Pattern)rce;
        context.setLastBuiltPattern(pattern);
        context.pushRuleComponent(pattern);
        this.attachPattern(context, utils, pattern);
        context.popRuleComponent();
    }

    private void attachPattern(BuildContext context, BuildUtils utils, Pattern pattern) throws InvalidPatternException {
        PropertyHandler handler;
        pattern.setOffset(context.getCurrentPatternOffset());
        if (ClassObjectType.Match_ObjectType.isAssignableFrom(pattern.getObjectType()) && (handler = PropertyHandlerFactory.getPropertyHandler(AgendaItemImpl.class)) == null) {
            MVELCompilationUnit.PropertyHandlerFactoryFixer.getPropertyHandlerClass().put(AgendaItemImpl.class, new ActivationPropertyHandler());
        }
        LinkedList<AlphaNodeFieldConstraint> alphaConstraints = new LinkedList<AlphaNodeFieldConstraint>();
        LinkedList<BetaNodeFieldConstraint> betaConstraints = new LinkedList<BetaNodeFieldConstraint>();
        List<Behavior> behaviors = pattern.getBehaviors();
        this.createConstraints(context, utils, pattern, alphaConstraints, betaConstraints);
        context.setBetaconstraints(betaConstraints);
        if (pattern.getSource() != null) {
            context.setAlphaConstraints(alphaConstraints);
            int currentOffset = context.getCurrentPatternOffset();
            PatternSource source = pattern.getSource();
            ReteooComponentBuilder builder = utils.getBuilderFor(source);
            if (builder == null) {
                throw new RuntimeException("Unknown pattern source type: " + source.getClass() + " for source " + source + " on pattern " + pattern);
            }
            builder.build(context, utils, source);
            context.setCurrentPatternOffset(currentOffset);
        } else {
            EntryPointId source = EntryPointId.DEFAULT;
            ReteooComponentBuilder builder = utils.getBuilderFor(source);
            builder.build(context, utils, source);
        }
        if (pattern.getSource() == null || !(pattern.getSource() instanceof WindowReference) && (context.getCurrentEntryPoint() != EntryPointId.DEFAULT || !behaviors.isEmpty())) {
            this.attachObjectTypeNode(context, utils, pattern);
        }
        if (!behaviors.isEmpty()) {
            WindowNode wn = context.getComponentFactory().getNodeFactoryService().buildWindowNode(context.getNextId(), alphaConstraints, behaviors, context.getObjectSource(), context);
            context.setObjectSource((WindowNode)utils.attachNode(context, wn));
            alphaConstraints.clear();
        }
        if (context.getObjectSource() != null) {
            this.attachAlphaNodes(context, utils, pattern, alphaConstraints);
        }
        context.incrementCurrentPatternOffset();
    }

    private void createConstraints(BuildContext context, BuildUtils utils, Pattern pattern, List<AlphaNodeFieldConstraint> alphaConstraints, List<BetaNodeFieldConstraint> betaConstraints) {
        List<Constraint> constraints = pattern.getConstraints();
        this.checkRemoveIdentities(context, pattern, betaConstraints);
        boolean isNegative = this.isNegative(context);
        for (Constraint object : constraints) {
            if (object instanceof Declaration) continue;
            Constraint constraint = object;
            if (constraint.getType().equals((Object)Constraint.ConstraintType.ALPHA)) {
                this.linkAlphaConstraint((AlphaNodeFieldConstraint)constraint, alphaConstraints);
                continue;
            }
            if (constraint.getType().equals((Object)Constraint.ConstraintType.BETA)) {
                this.linkBetaConstraint((BetaNodeFieldConstraint)constraint, betaConstraints);
                if (!isNegative || context.getKnowledgeBase().getConfiguration().getEventProcessingMode() != EventProcessingOption.STREAM || !pattern.getObjectType().isEvent() || !constraint.isTemporal()) continue;
                this.checkDelaying(context, constraint);
                continue;
            }
            throw new RuntimeException("Unknown constraint type: " + (Object)((Object)constraint.getType()) + ". This is a bug. Please contact development team.");
        }
    }

    protected void linkBetaConstraint(BetaNodeFieldConstraint constraint, List<BetaNodeFieldConstraint> betaConstraints) {
        betaConstraints.add(constraint);
    }

    protected void linkAlphaConstraint(AlphaNodeFieldConstraint constraint, List<AlphaNodeFieldConstraint> alphaConstraints) {
        alphaConstraints.add(constraint);
    }

    private void checkDelaying(BuildContext context, Constraint constraint) {
        long uplimit;
        Declaration target;
        if (constraint instanceof IntervalProviderConstraint && (target = constraint.getRequiredDeclarations()[0]).isPatternDeclaration() && target.getPattern().getObjectType().isEvent() && (uplimit = ((IntervalProviderConstraint)constraint).getInterval().getUpperBound()) >= 0L && uplimit < Long.MAX_VALUE) {
            Timer timer = context.getRule().getTimer();
            DurationTimer durationTimer = new DurationTimer(uplimit);
            durationTimer.setEventFactHandle(target);
            if (timer instanceof CompositeMaxDurationTimer) {
                ((CompositeMaxDurationTimer)timer).addDurationTimer(durationTimer);
            } else {
                if (timer == null) {
                    timer = durationTimer;
                } else {
                    CompositeMaxDurationTimer temp = new CompositeMaxDurationTimer();
                    if (timer instanceof DurationTimer) {
                        temp.addDurationTimer((DurationTimer)timer);
                    } else {
                        temp.setTimer(context.getRule().getTimer());
                    }
                    temp.addDurationTimer(durationTimer);
                    timer = temp;
                }
                context.getRule().setTimer(timer);
            }
        }
    }

    private boolean isNegative(BuildContext context) {
        ListIterator<RuleConditionElement> it = context.stackIterator();
        while (it.hasPrevious()) {
            RuleConditionElement rce = it.previous();
            if (!(rce instanceof GroupElement) || !((GroupElement)rce).isNot()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectTypeNode attachObjectTypeNode(BuildContext context, ObjectType objectType) {
        InternalKnowledgeBase ruleBase = context.getKnowledgeBase();
        ruleBase.lock();
        try {
            InternalWorkingMemory[] wms = context.getWorkingMemories();
            NodeFactory nfactory = context.getComponentFactory().getNodeFactoryService();
            EntryPointNode epn = ruleBase.getRete().getEntryPointNode(context.getCurrentEntryPoint());
            if (epn == null) {
                epn = nfactory.buildEntryPointNode(context.getNextId(), ruleBase.getRete(), context);
                epn.attach(context);
            }
            ObjectTypeNode otn = nfactory.buildObjectTypeNode(context.getNextId(), epn, objectType, context);
            long expirationOffset = PatternBuilder.getExpiratioOffsetForType(context, objectType);
            otn.setExpirationOffset(expirationOffset);
            otn.attach(context);
            ObjectTypeNode objectTypeNode = otn;
            return objectTypeNode;
        }
        finally {
            ruleBase.unlock();
        }
    }

    private static long getExpiratioOffsetForType(BuildContext context, ObjectType objectType) {
        long expirationOffset = -1L;
        for (TypeDeclaration type : context.getKnowledgeBase().getTypeDeclarations()) {
            if (!type.getObjectType().isAssignableFrom(objectType)) continue;
            expirationOffset = Math.max(type.getExpirationOffset(), expirationOffset);
        }
        return expirationOffset == -1L ? -1L : expirationOffset + 1L;
    }

    public void attachAlphaNodes(BuildContext context, BuildUtils utils, Pattern pattern, List<AlphaNodeFieldConstraint> alphaConstraints) throws InvalidPatternException {
        this.buildAlphaNodeChain(context, utils, pattern, alphaConstraints);
        NodeFactory nfactory = context.getComponentFactory().getNodeFactoryService();
        if (context.getCurrentEntryPoint() != EntryPointId.DEFAULT && context.isAttachPQN()) {
            if (!context.getKnowledgeBase().getConfiguration().isPhreakEnabled()) {
                context.setObjectSource((ObjectSource)utils.attachNode(context, nfactory.buildPropagationQueuingNode(context.getNextId(), context.getObjectSource(), context)));
            }
            context.setCurrentEntryPoint(EntryPointId.DEFAULT);
        }
    }

    protected void buildAlphaNodeChain(BuildContext context, BuildUtils utils, Pattern pattern, List<AlphaNodeFieldConstraint> alphaConstraints) {
        for (AlphaNodeFieldConstraint constraint : alphaConstraints) {
            context.pushRuleComponent(constraint);
            context.setObjectSource((ObjectSource)utils.attachNode(context, context.getComponentFactory().getNodeFactoryService().buildAlphaNode(context.getNextId(), constraint, context.getObjectSource(), context)));
            context.popRuleComponent();
        }
    }

    private void attachObjectTypeNode(BuildContext context, BuildUtils utils, Pattern pattern) {
        boolean objectMemory = context.isObjectTypeNodeMemoryEnabled();
        ObjectType objectType = pattern.getObjectType();
        if (pattern.getObjectType() instanceof ClassObjectType && DroolsQuery.class == ((ClassObjectType)pattern.getObjectType()).getClassType()) {
            context.setTupleMemoryEnabled(false);
            context.setObjectTypeNodeMemoryEnabled(false);
        }
        ObjectTypeNode otn = context.getComponentFactory().getNodeFactoryService().buildObjectTypeNode(context.getNextId(), (EntryPointNode)context.getObjectSource(), objectType, context);
        if (objectType.isEvent() && EventProcessingOption.STREAM.equals((Object)context.getKnowledgeBase().getConfiguration().getEventProcessingMode())) {
            long expirationOffset = PatternBuilder.getExpiratioOffsetForType(context, objectType);
            if (expirationOffset != -1L) {
                otn.setExpirationOffset(expirationOffset);
            } else {
                long distance;
                for (Behavior behavior : pattern.getBehaviors()) {
                    if (behavior.getExpirationOffset() == -1L) continue;
                    expirationOffset = Math.max(behavior.getExpirationOffset(), expirationOffset);
                }
                long l = distance = context.getTemporalDistance() != null ? context.getTemporalDistance().getExpirationOffset(pattern) : -1L;
                if (distance == -1L) {
                    otn.setExpirationOffset(expirationOffset);
                } else {
                    otn.setExpirationOffset(Math.max(distance, expirationOffset));
                }
            }
        }
        context.setObjectSource((ObjectSource)utils.attachNode(context, otn));
        context.setObjectTypeNodeMemoryEnabled(objectMemory);
    }

    private void checkRemoveIdentities(BuildContext context, Pattern pattern, List<BetaNodeFieldConstraint> betaConstraints) {
        if (context.getKnowledgeBase().getConfiguration().isRemoveIdentities() && pattern.getObjectType().getClass() == ClassObjectType.class) {
            Class<?> thisClass = ((ClassObjectType)pattern.getObjectType()).getClassType();
            for (Pattern previousPattern : context.getObjectType()) {
                Class<?> previousClass = ((ClassObjectType)previousPattern.getObjectType()).getClassType();
                if (!thisClass.isAssignableFrom(previousClass)) continue;
                betaConstraints.add(new InstanceNotEqualsConstraint(previousPattern));
            }
            context.getObjectType().add(pattern);
        }
    }

    @Override
    public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
        return ((Pattern)rce).getSource() != null || !((Pattern)rce).getBehaviors().isEmpty();
    }
}

