/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.solver.move;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.cheaptime.domain.TaskAssignment;

public class CheapTimePillarSlideMove
extends AbstractMove {
    private final List<TaskAssignment> pillar;
    private final int startPeriodDiff;

    public CheapTimePillarSlideMove(List<TaskAssignment> pillar, int startPeriodDiff) {
        this.pillar = pillar;
        this.startPeriodDiff = startPeriodDiff;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return true;
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new CheapTimePillarSlideMove(this.pillar, -this.startPeriodDiff);
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        for (TaskAssignment taskAssignment : this.pillar) {
            scoreDirector.beforeVariableChanged(taskAssignment, "startPeriod");
            taskAssignment.setStartPeriod(taskAssignment.getStartPeriod() + this.startPeriodDiff);
            scoreDirector.afterVariableChanged(taskAssignment, "startPeriod");
        }
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.pillar);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        ArrayList<Integer> startPeriodList = new ArrayList<Integer>(this.pillar.size());
        for (TaskAssignment taskAssignment : this.pillar) {
            startPeriodList.add(taskAssignment.getStartPeriod());
        }
        return Collections.singletonList(startPeriodList);
    }
}

