/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.dinnerparty.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.swingui.components.Labeled;
import org.optaplanner.examples.dinnerparty.domain.Gender;
import org.optaplanner.examples.dinnerparty.domain.Guest;
import org.optaplanner.examples.dinnerparty.domain.Job;
import org.optaplanner.examples.dinnerparty.domain.JobType;
import org.optaplanner.examples.dinnerparty.domain.Seat;
import org.optaplanner.examples.dinnerparty.domain.Table;

@PlanningEntity
@XStreamAlias(value="SeatDesignation")
public class SeatDesignation
extends AbstractPersistable
implements Labeled {
    private Guest guest;
    private Seat seat;

    public Guest getGuest() {
        return this.guest;
    }

    public void setGuest(Guest guest) {
        this.guest = guest;
    }

    @PlanningVariable(valueRangeProviderRefs={"seatRange"})
    public Seat getSeat() {
        return this.seat;
    }

    public void setSeat(Seat seat) {
        this.seat = seat;
    }

    public String getGuestName() {
        return this.getGuest().getName();
    }

    public Gender getGuestGender() {
        return this.getGuest().getGender();
    }

    public Job getGuestJob() {
        return this.getGuest().getJob();
    }

    public JobType getGuestJobType() {
        return this.getGuest().getJob().getJobType();
    }

    public boolean differentKindIfNeeded(Job otherGuestJob) {
        JobType jobType = this.guest.getJob().getJobType();
        return jobType == JobType.SOCIALITE || jobType == JobType.TEACHER || this.guest.getJob() != otherGuestJob;
    }

    public Table getSeatTable() {
        if (this.seat == null) {
            return null;
        }
        return this.seat.getTable();
    }

    public boolean isRightOf(SeatDesignation leftSeatDesignation) {
        if (this.seat == null || leftSeatDesignation.seat == null) {
            return false;
        }
        return this.seat.getRightSeat() == leftSeatDesignation.seat;
    }

    public boolean isNeighborOf(SeatDesignation otherSeatDesignation) {
        if (this.seat == null || otherSeatDesignation.seat == null) {
            return false;
        }
        return this.seat.getLeftSeat() == otherSeatDesignation.seat || this.seat.getRightSeat() == otherSeatDesignation.seat;
    }

    @Override
    public String getLabel() {
        return this.guest.getLabel();
    }

    @Override
    public String toString() {
        return this.guest + " @ " + this.seat;
    }
}

