/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.app;

import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.persistence.AbstractSolutionExporter;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionDao;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.tsp.persistence.TspDao;
import org.optaplanner.examples.tsp.persistence.TspExporter;
import org.optaplanner.examples.tsp.persistence.TspImporter;
import org.optaplanner.examples.tsp.swingui.TspPanel;

public class TspApp
extends CommonApp {
    public static final String SOLVER_CONFIG = "org/optaplanner/examples/tsp/solver/tspSolverConfig.xml";

    public static void main(String[] args) {
        TspApp.prepareSwingEnvironment();
        new TspApp().init();
    }

    public TspApp() {
        super("Traveling salesman", "Official competition name: TSP - Traveling salesman problem\n\nDetermine the order in which to visit all cities.\n\nFind the shortest route to visit all cities.", "/org/optaplanner/examples/tsp/swingui/tspLogo.png");
    }

    @Override
    protected Solver createSolver() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource(SOLVER_CONFIG);
        return solverFactory.buildSolver();
    }

    @Override
    protected SolutionPanel createSolutionPanel() {
        return new TspPanel();
    }

    @Override
    protected SolutionDao createSolutionDao() {
        return new TspDao();
    }

    @Override
    protected AbstractSolutionImporter createSolutionImporter() {
        return new TspImporter();
    }

    @Override
    protected AbstractSolutionExporter createSolutionExporter() {
        return new TspExporter();
    }
}

