/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;
import org.optaplanner.examples.common.swingui.TangoColorFactory;
import org.optaplanner.examples.common.swingui.latitudelongitude.LatitudeLongitudeTranslator;
import org.optaplanner.examples.tsp.domain.Domicile;
import org.optaplanner.examples.tsp.domain.TravelingSalesmanTour;
import org.optaplanner.examples.tsp.domain.Visit;
import org.optaplanner.examples.tsp.domain.location.AirLocation;
import org.optaplanner.examples.tsp.domain.location.DistanceType;
import org.optaplanner.examples.tsp.domain.location.Location;
import org.optaplanner.examples.tsp.swingui.TspPanel;

public class TspWorldPanel
extends JPanel {
    private static final int TEXT_SIZE = 12;
    private static final int LOCATION_NAME_TEXT_SIZE = 8;
    private static final NumberFormat NUMBER_FORMAT = new DecimalFormat("#,##0.00");
    private final TspPanel tspPanel;
    private BufferedImage canvas = null;
    private LatitudeLongitudeTranslator translator = null;
    private ImageIcon europaBackground;

    public TspWorldPanel(TspPanel tspPanel) {
        this.tspPanel = tspPanel;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TravelingSalesmanTour travelingSalesmanTour = TspWorldPanel.this.tspPanel.getTravelingSalesmanTour();
                if (travelingSalesmanTour != null) {
                    TspWorldPanel.this.resetPanel(travelingSalesmanTour);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (TspWorldPanel.this.translator != null) {
                    double longitude = TspWorldPanel.this.translator.translateXToLongitude(e.getX());
                    double latitude = TspWorldPanel.this.translator.translateYToLatitude(e.getY());
                    TspWorldPanel.this.tspPanel.insertLocationAndVisit(longitude, latitude);
                }
            }
        });
        this.europaBackground = new ImageIcon(this.getClass().getResource("europaBackground.png"));
    }

    public void resetPanel(TravelingSalesmanTour travelingSalesmanTour) {
        this.translator = new LatitudeLongitudeTranslator();
        for (Location location : travelingSalesmanTour.getLocationList()) {
            this.translator.addCoordinates(location.getLatitude(), location.getLongitude());
        }
        Dimension size = this.getSize();
        double width = size.getWidth();
        double height = size.getHeight();
        this.translator.prepareFor(width, height);
        Graphics2D g = this.createCanvas(width, height);
        String tourName = travelingSalesmanTour.getName();
        if (tourName.startsWith("europe")) {
            g.drawImage(this.europaBackground.getImage(), 0, 0, this.translator.getImageWidth(), this.translator.getImageHeight(), this);
        }
        g.setFont(g.getFont().deriveFont(8.0f));
        g.setColor(TangoColorFactory.PLUM_2);
        List<Visit> visitList = travelingSalesmanTour.getVisitList();
        for (Visit visit : visitList) {
            Location location = visit.getLocation();
            int x = this.translator.translateLongitudeToX(location.getLongitude());
            int y = this.translator.translateLatitudeToY(location.getLatitude());
            g.fillRect(x - 1, y - 1, 3, 3);
            if (location.getName() == null || visitList.size() > 500) continue;
            g.drawString(location.getName(), x + 3, y - 3);
        }
        g.setColor(TangoColorFactory.ALUMINIUM_4);
        Domicile domicile = travelingSalesmanTour.getDomicile();
        Location domicileLocation = domicile.getLocation();
        int domicileX = this.translator.translateLongitudeToX(domicileLocation.getLongitude());
        int domicileY = this.translator.translateLatitudeToY(domicileLocation.getLatitude());
        g.fillRect(domicileX - 2, domicileY - 2, 5, 5);
        if (domicileLocation.getName() != null && visitList.size() <= 500) {
            g.drawString(domicileLocation.getName(), domicileX + 3, domicileY - 3);
        }
        HashSet<Visit> needsBackToDomicileLineSet = new HashSet<Visit>(visitList);
        for (Visit trailingVisit : visitList) {
            if (!(trailingVisit.getPreviousStandstill() instanceof Visit)) continue;
            needsBackToDomicileLineSet.remove(trailingVisit.getPreviousStandstill());
        }
        g.setColor(TangoColorFactory.CHOCOLATE_1);
        for (Visit visit : visitList) {
            if (visit.getPreviousStandstill() == null) continue;
            Location previousLocation = visit.getPreviousStandstill().getLocation();
            Location location = visit.getLocation();
            this.translator.drawRoute(g, previousLocation.getLongitude(), previousLocation.getLatitude(), location.getLongitude(), location.getLatitude(), location instanceof AirLocation);
            if (!needsBackToDomicileLineSet.contains(visit)) continue;
            this.translator.drawRoute(g, location.getLongitude(), location.getLatitude(), domicileLocation.getLongitude(), domicileLocation.getLatitude(), location instanceof AirLocation);
        }
        g.setColor(TangoColorFactory.ALUMINIUM_4);
        g.fillRect(5, (int)height - 15 - 12, 5, 5);
        g.drawString("Domicile", 15, (int)height - 10 - 12);
        g.setColor(TangoColorFactory.PLUM_2);
        g.fillRect(6, (int)height - 9, 3, 3);
        g.drawString("Visit", 15, (int)height - 5);
        g.setColor(TangoColorFactory.ALUMINIUM_5);
        String locationsSizeString = travelingSalesmanTour.getLocationList().size() + " locations";
        g.drawString(locationsSizeString, ((int)width - g.getFontMetrics().stringWidth(locationsSizeString)) / 2, (int)height - 5);
        if (travelingSalesmanTour.getDistanceType() == DistanceType.AIR_DISTANCE) {
            String clickString = "Click anywhere in the map to add a visit.";
            g.drawString(clickString, (int)width - 5 - g.getFontMetrics().stringWidth(clickString), (int)height - 5);
        }
        g.setColor(TangoColorFactory.ORANGE_3);
        SimpleLongScore score = travelingSalesmanTour.getScore();
        if (score != null) {
            double fuel = (double)(-score.getScore()) / 1000.0;
            String fuelString = NUMBER_FORMAT.format(fuel) + " fuel";
            g.setFont(g.getFont().deriveFont(1, 24.0f));
            g.drawString(fuelString, (int)width - g.getFontMetrics().stringWidth(fuelString) - 10, (int)height - 10 - 12);
        }
        this.repaint();
    }

    public void updatePanel(TravelingSalesmanTour travelingSalesmanTour) {
        this.resetPanel(travelingSalesmanTour);
    }

    private Graphics2D createCanvas(double width, double height) {
        int canvasWidth = (int)Math.ceil(width) + 1;
        int canvasHeight = (int)Math.ceil(height) + 1;
        this.canvas = new BufferedImage(canvasWidth, canvasHeight, 1);
        Graphics2D g = this.canvas.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, canvasWidth, canvasHeight);
        return g;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.canvas != null) {
            g.drawImage(this.canvas, 0, 0, this);
        }
    }
}

