/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.localsearch.decider.forager;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.localsearch.decider.forager.FinalistPodiumType;
import org.optaplanner.core.config.localsearch.decider.forager.LocalSearchPickEarlyType;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.localsearch.decider.forager.AcceptedForager;
import org.optaplanner.core.impl.localsearch.decider.forager.Forager;
import org.optaplanner.core.impl.localsearch.decider.forager.finalist.FinalistPodium;
import org.optaplanner.core.impl.localsearch.decider.forager.finalist.HighestScoreFinalistPodium;

@XStreamAlias(value="localSearchForagerConfig")
public class LocalSearchForagerConfig {
    private Class<? extends Forager> foragerClass = null;
    protected LocalSearchPickEarlyType pickEarlyType = null;
    protected Integer acceptedCountLimit = null;
    protected FinalistPodiumType finalistPodiumType = null;

    public Class<? extends Forager> getForagerClass() {
        return this.foragerClass;
    }

    public void setForagerClass(Class<? extends Forager> foragerClass) {
        this.foragerClass = foragerClass;
    }

    public LocalSearchPickEarlyType getPickEarlyType() {
        return this.pickEarlyType;
    }

    public void setPickEarlyType(LocalSearchPickEarlyType pickEarlyType) {
        this.pickEarlyType = pickEarlyType;
    }

    public Integer getAcceptedCountLimit() {
        return this.acceptedCountLimit;
    }

    public void setAcceptedCountLimit(Integer acceptedCountLimit) {
        this.acceptedCountLimit = acceptedCountLimit;
    }

    public FinalistPodiumType getFinalistPodiumType() {
        return this.finalistPodiumType;
    }

    public void setFinalistPodiumType(FinalistPodiumType finalistPodiumType) {
        this.finalistPodiumType = finalistPodiumType;
    }

    public Forager buildForager(HeuristicConfigPolicy configPolicy) {
        if (this.foragerClass != null) {
            if (this.pickEarlyType != null || this.acceptedCountLimit != null || this.finalistPodiumType != null) {
                throw new IllegalArgumentException("The foragerConfig with foragerClass (" + this.foragerClass + ") must not also have a pickEarlyType (" + (Object)((Object)this.pickEarlyType) + "), acceptedCountLimit (" + this.acceptedCountLimit + ") or finalistPodiumType (" + (Object)((Object)this.finalistPodiumType) + ").");
            }
            return ConfigUtils.newInstance(this, "foragerClass", this.foragerClass);
        }
        LocalSearchPickEarlyType pickEarlyType_ = this.pickEarlyType == null ? LocalSearchPickEarlyType.NEVER : this.pickEarlyType;
        int acceptedCountLimit_ = this.acceptedCountLimit == null ? Integer.MAX_VALUE : this.acceptedCountLimit;
        FinalistPodium finalistPodium = this.finalistPodiumType == null ? new HighestScoreFinalistPodium() : this.finalistPodiumType.buildFinalistPodium();
        return new AcceptedForager(finalistPodium, pickEarlyType_, acceptedCountLimit_);
    }

    public void inherit(LocalSearchForagerConfig inheritedConfig) {
        this.foragerClass = ConfigUtils.inheritOverwritableProperty(this.foragerClass, inheritedConfig.getForagerClass());
        this.pickEarlyType = ConfigUtils.inheritOverwritableProperty(this.pickEarlyType, inheritedConfig.getPickEarlyType());
        this.acceptedCountLimit = ConfigUtils.inheritOverwritableProperty(this.acceptedCountLimit, inheritedConfig.getAcceptedCountLimit());
        this.finalistPodiumType = ConfigUtils.inheritOverwritableProperty(this.finalistPodiumType, inheritedConfig.getFinalistPodiumType());
    }
}

