/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.listener;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.StatefulVariableListener;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.domain.variable.supply.Demand;
import org.optaplanner.core.impl.domain.variable.supply.Supply;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class VariableListenerSupport
implements SupplyManager {
    protected final InnerScoreDirector scoreDirector;
    protected final Map<VariableDescriptor, List<VariableListener>> variableListenerMap;
    protected final Map<EntityDescriptor, List<VariableListener>> entityVariableListenerMap;
    protected final Map<Demand, Supply> supplyMap;

    public VariableListenerSupport(InnerScoreDirector scoreDirector) {
        this.scoreDirector = scoreDirector;
        this.variableListenerMap = new LinkedHashMap<VariableDescriptor, List<VariableListener>>();
        this.entityVariableListenerMap = new LinkedHashMap<EntityDescriptor, List<VariableListener>>();
        this.supplyMap = new LinkedHashMap<Demand, Supply>(this.variableListenerMap.size());
    }

    public void linkVariableListeners() {
        for (EntityDescriptor entityDescriptor : this.scoreDirector.getSolutionDescriptor().getEntityDescriptors()) {
            ArrayList<VariableListener> entityVariableListenerList = new ArrayList<VariableListener>();
            for (GenuineVariableDescriptor genuineVariableDescriptor : entityDescriptor.getDeclaredGenuineVariableDescriptors()) {
                this.buildVariableListeners(entityVariableListenerList, genuineVariableDescriptor);
            }
            for (ShadowVariableDescriptor shadowVariableDescriptor : entityDescriptor.getDeclaredShadowVariableDescriptors()) {
                this.buildVariableListeners(entityVariableListenerList, shadowVariableDescriptor);
            }
            this.entityVariableListenerMap.put(entityDescriptor, entityVariableListenerList);
        }
    }

    public void buildVariableListeners(List<VariableListener> entityVariableListenerList, VariableDescriptor variableDescriptor) {
        List<ShadowVariableDescriptor> shadowVariableDescriptorList = variableDescriptor.getShadowVariableDescriptorList();
        ArrayList<VariableListener> variableListenerList = new ArrayList<VariableListener>(shadowVariableDescriptorList.size());
        for (ShadowVariableDescriptor shadowVariableDescriptor : shadowVariableDescriptorList) {
            VariableListener variableListener = shadowVariableDescriptor.buildVariableListener(this.scoreDirector);
            variableListenerList.add(variableListener);
            this.supplyMap.put(shadowVariableDescriptor.getProvidedDemand(), variableListener);
        }
        this.variableListenerMap.put(variableDescriptor, variableListenerList);
        entityVariableListenerList.addAll(variableListenerList);
    }

    @Override
    public <S extends Supply> S demand(Demand<S> demand) {
        Supply supply = this.supplyMap.get(demand);
        if (supply == null) {
            supply = demand.createExternalizedSupply(this.scoreDirector);
            if (supply instanceof StatefulVariableListener) {
                StatefulVariableListener statefulVariableListener = (StatefulVariableListener)supply;
                statefulVariableListener.resetWorkingSolution(this.scoreDirector);
                VariableDescriptor sourceVariableDescriptor = statefulVariableListener.getSourceVariableDescriptor();
                List<VariableListener> variableListenerList = this.variableListenerMap.get(sourceVariableDescriptor);
                if (variableListenerList == null) {
                    variableListenerList = new ArrayList<VariableListener>();
                    this.variableListenerMap.put(sourceVariableDescriptor, variableListenerList);
                }
                variableListenerList.add(statefulVariableListener);
                EntityDescriptor entityDescriptor = sourceVariableDescriptor.getEntityDescriptor();
                List<VariableListener> entityVariableListenerList = this.entityVariableListenerMap.get(entityDescriptor);
                if (entityVariableListenerList == null) {
                    entityVariableListenerList = new ArrayList<VariableListener>();
                    this.entityVariableListenerMap.put(entityDescriptor, entityVariableListenerList);
                }
                entityVariableListenerList.add(statefulVariableListener);
            }
            this.supplyMap.put(demand, supply);
        }
        return (S)supply;
    }

    public void resetWorkingSolution(InnerScoreDirector scoreDirector) {
        for (List<VariableListener> variableListenerList : this.variableListenerMap.values()) {
            for (VariableListener variableListener : variableListenerList) {
                if (!(variableListener instanceof StatefulVariableListener)) continue;
                ((StatefulVariableListener)variableListener).resetWorkingSolution(scoreDirector);
            }
        }
    }

    public void clearWorkingSolution(InnerScoreDirector scoreDirector) {
        for (List<VariableListener> variableListenerList : this.variableListenerMap.values()) {
            for (VariableListener variableListener : variableListenerList) {
                if (!(variableListener instanceof StatefulVariableListener)) continue;
                ((StatefulVariableListener)variableListener).clearWorkingSolution(scoreDirector);
            }
        }
    }

    public void beforeEntityAdded(InnerScoreDirector scoreDirector, EntityDescriptor entityDescriptor, Object entity) {
        for (VariableListener variableListener : this.entityVariableListenerMap.get(entityDescriptor)) {
            variableListener.beforeEntityAdded(scoreDirector, entity);
        }
    }

    public void afterEntityAdded(InnerScoreDirector scoreDirector, EntityDescriptor entityDescriptor, Object entity) {
        for (VariableListener variableListener : this.entityVariableListenerMap.get(entityDescriptor)) {
            variableListener.afterEntityAdded(scoreDirector, entity);
        }
    }

    public void beforeVariableChanged(InnerScoreDirector scoreDirector, VariableDescriptor variableDescriptor, Object entity) {
        for (VariableListener variableListener : this.variableListenerMap.get(variableDescriptor)) {
            variableListener.beforeVariableChanged(scoreDirector, entity);
        }
    }

    public void afterVariableChanged(InnerScoreDirector scoreDirector, VariableDescriptor variableDescriptor, Object entity) {
        for (VariableListener variableListener : this.variableListenerMap.get(variableDescriptor)) {
            variableListener.afterVariableChanged(scoreDirector, entity);
        }
    }

    public void beforeEntityRemoved(InnerScoreDirector scoreDirector, EntityDescriptor entityDescriptor, Object entity) {
        for (VariableListener variableListener : this.entityVariableListenerMap.get(entityDescriptor)) {
            variableListener.beforeEntityRemoved(scoreDirector, entity);
        }
    }

    public void afterEntityRemoved(InnerScoreDirector scoreDirector, EntityDescriptor entityDescriptor, Object entity) {
        for (VariableListener variableListener : this.entityVariableListenerMap.get(entityDescriptor)) {
            variableListener.afterEntityRemoved(scoreDirector, entity);
        }
    }
}

