/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.List;
import java.util.ListIterator;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class ChainedMoveUtils {
    public static void doChainedChange(ScoreDirector scoreDirector, Object entity, GenuineVariableDescriptor variableDescriptor, Object toPlanningValue) {
        Object newTrailingEntity;
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        Object oldValue = variableDescriptor.getValue(entity);
        Object oldTrailingEntity = innerScoreDirector.getTrailingEntity(variableDescriptor, entity);
        Object object = newTrailingEntity = toPlanningValue == null ? null : innerScoreDirector.getTrailingEntity(variableDescriptor, toPlanningValue);
        if (oldTrailingEntity != null) {
            scoreDirector.beforeVariableChanged(variableDescriptor, oldTrailingEntity);
        }
        scoreDirector.beforeVariableChanged(variableDescriptor, entity);
        if (newTrailingEntity != null) {
            scoreDirector.beforeVariableChanged(variableDescriptor, newTrailingEntity);
        }
        if (oldTrailingEntity != null) {
            variableDescriptor.setValue(oldTrailingEntity, oldValue);
        }
        variableDescriptor.setValue(entity, toPlanningValue);
        if (newTrailingEntity != null) {
            variableDescriptor.setValue(newTrailingEntity, entity);
        }
        if (oldTrailingEntity != null) {
            scoreDirector.afterVariableChanged(variableDescriptor, oldTrailingEntity);
        }
        scoreDirector.afterVariableChanged(variableDescriptor, entity);
        if (newTrailingEntity != null) {
            scoreDirector.afterVariableChanged(variableDescriptor, newTrailingEntity);
        }
    }

    public static void doSubChainChange(ScoreDirector scoreDirector, SubChain subChain, GenuineVariableDescriptor variableDescriptor, Object toPlanningValue) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        Object firstEntity = subChain.getFirstEntity();
        Object lastEntity = subChain.getLastEntity();
        Object oldFirstValue = variableDescriptor.getValue(firstEntity);
        Object oldTrailingEntity = innerScoreDirector.getTrailingEntity(variableDescriptor, lastEntity);
        Object newTrailingEntity = innerScoreDirector.getTrailingEntity(variableDescriptor, toPlanningValue);
        if (oldTrailingEntity != null) {
            scoreDirector.beforeVariableChanged(variableDescriptor, oldTrailingEntity);
        }
        scoreDirector.beforeVariableChanged(variableDescriptor, firstEntity);
        if (newTrailingEntity != null) {
            scoreDirector.beforeVariableChanged(variableDescriptor, newTrailingEntity);
        }
        if (oldTrailingEntity != null) {
            variableDescriptor.setValue(oldTrailingEntity, oldFirstValue);
        }
        variableDescriptor.setValue(firstEntity, toPlanningValue);
        if (newTrailingEntity != null) {
            variableDescriptor.setValue(newTrailingEntity, lastEntity);
        }
        if (oldTrailingEntity != null) {
            scoreDirector.afterVariableChanged(variableDescriptor, oldTrailingEntity);
        }
        scoreDirector.afterVariableChanged(variableDescriptor, firstEntity);
        if (newTrailingEntity != null) {
            scoreDirector.afterVariableChanged(variableDescriptor, newTrailingEntity);
        }
    }

    public static void doReverseSubChainChange(ScoreDirector scoreDirector, SubChain subChain, GenuineVariableDescriptor variableDescriptor, Object toPlanningValue) {
        Object entity;
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        Object firstEntity = subChain.getFirstEntity();
        Object lastEntity = subChain.getLastEntity();
        Object oldFirstValue = variableDescriptor.getValue(firstEntity);
        Object oldTrailingEntity = innerScoreDirector.getTrailingEntity(variableDescriptor, lastEntity);
        Object newTrailingEntity = innerScoreDirector.getTrailingEntity(variableDescriptor, toPlanningValue);
        boolean unmovedReverse = firstEntity == newTrailingEntity;
        List<Object> entityList = subChain.getEntityList();
        if (oldTrailingEntity != null) {
            scoreDirector.beforeVariableChanged(variableDescriptor, oldTrailingEntity);
        }
        ListIterator<Object> it = entityList.listIterator(entityList.size());
        while (it.hasPrevious()) {
            Object entity2 = it.previous();
            scoreDirector.beforeVariableChanged(variableDescriptor, entity2);
        }
        if (!unmovedReverse && newTrailingEntity != null) {
            scoreDirector.beforeVariableChanged(variableDescriptor, newTrailingEntity);
        }
        if (oldTrailingEntity != null) {
            variableDescriptor.setValue(oldTrailingEntity, oldFirstValue);
        }
        Object nextEntity = toPlanningValue;
        ListIterator<Object> it2 = entityList.listIterator(entityList.size());
        while (it2.hasPrevious()) {
            entity = it2.previous();
            variableDescriptor.setValue(entity, nextEntity);
            nextEntity = entity;
        }
        if (unmovedReverse) {
            if (oldTrailingEntity != null) {
                variableDescriptor.setValue(oldTrailingEntity, firstEntity);
            }
        } else if (newTrailingEntity != null) {
            variableDescriptor.setValue(newTrailingEntity, firstEntity);
        }
        if (oldTrailingEntity != null) {
            scoreDirector.afterVariableChanged(variableDescriptor, oldTrailingEntity);
        }
        it2 = entityList.listIterator(entityList.size());
        while (it2.hasPrevious()) {
            entity = it2.previous();
            scoreDirector.afterVariableChanged(variableDescriptor, entity);
        }
        if (!unmovedReverse && newTrailingEntity != null) {
            scoreDirector.afterVariableChanged(variableDescriptor, newTrailingEntity);
        }
    }

    private ChainedMoveUtils() {
    }
}

