/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score;

import org.optaplanner.core.api.score.Score;

public class ScoreUtils {
    public static double[] extractLevelDoubles(Score score) {
        Number[] levelNumbers = score.toLevelNumbers();
        double[] levelDoubles = new double[levelNumbers.length];
        for (int i = 0; i < levelNumbers.length; ++i) {
            levelDoubles[i] = levelNumbers[i].doubleValue();
        }
        return levelDoubles;
    }

    public static double calculateTimeGradient(Number[] totalDiffNumbers, Number[] scoreDiffNumbers, double[] timeGradientWeightNumbers, int levelDepth) {
        double timeGradient = 0.0;
        double remainingTimeGradient = 1.0;
        for (int i = 0; i < levelDepth; ++i) {
            double levelTimeGradientWeight;
            if (i != levelDepth - 1) {
                levelTimeGradientWeight = remainingTimeGradient * timeGradientWeightNumbers[i];
                remainingTimeGradient -= levelTimeGradientWeight;
            } else {
                levelTimeGradientWeight = remainingTimeGradient;
                remainingTimeGradient = 0.0;
            }
            double totalDiffLevel = totalDiffNumbers[i].doubleValue();
            double scoreDiffLevel = scoreDiffNumbers[i].doubleValue();
            if (scoreDiffLevel == totalDiffLevel) {
                timeGradient += levelTimeGradientWeight;
                continue;
            }
            if (scoreDiffLevel > totalDiffLevel) {
                timeGradient += levelTimeGradientWeight + remainingTimeGradient;
                break;
            }
            if (scoreDiffLevel == 0.0) continue;
            if (scoreDiffLevel < 0.0) break;
            double levelTimeGradient = scoreDiffLevel / totalDiffLevel;
            timeGradient += levelTimeGradient * levelTimeGradientWeight;
        }
        if (timeGradient > 1.0) {
            timeGradient = 1.0;
        }
        return timeGradient;
    }

    private ScoreUtils() {
    }
}

