/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.solver;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.solver.EmptySolverFactory;
import org.optaplanner.core.impl.solver.XStreamXmlSolverFactory;

public abstract class SolverFactory {
    public static SolverFactory createEmpty() {
        return new EmptySolverFactory();
    }

    public static SolverFactory createEmpty(ClassLoader classLoader) {
        return new EmptySolverFactory(classLoader);
    }

    public static SolverFactory createFromXmlResource(String solverConfigResource) {
        return new XStreamXmlSolverFactory().configure(solverConfigResource);
    }

    public static SolverFactory createFromXmlResource(String solverConfigResource, ClassLoader classLoader) {
        return new XStreamXmlSolverFactory(classLoader).configure(solverConfigResource);
    }

    public static SolverFactory createFromXmlFile(File solverConfigFile) {
        return new XStreamXmlSolverFactory().configure(solverConfigFile);
    }

    public static SolverFactory createFromXmlFile(File solverConfigFile, ClassLoader classLoader) {
        return new XStreamXmlSolverFactory(classLoader).configure(solverConfigFile);
    }

    public static SolverFactory createFromXmlInputStream(InputStream in) {
        return new XStreamXmlSolverFactory().configure(in);
    }

    public static SolverFactory createFromXmlInputStream(InputStream in, ClassLoader classLoader) {
        return new XStreamXmlSolverFactory(classLoader).configure(in);
    }

    public static SolverFactory createFromXmlReader(Reader reader) {
        return new XStreamXmlSolverFactory().configure(reader);
    }

    public static SolverFactory createFromXmlReader(Reader reader, ClassLoader classLoader) {
        return new XStreamXmlSolverFactory(classLoader).configure(reader);
    }

    public abstract SolverConfig getSolverConfig();

    public abstract Solver buildSolver();
}

