/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.descriptor;

import com.google.common.collect.Iterators;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningEntityProperty;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.domain.solution.cloner.PlanningCloneable;
import org.optaplanner.core.api.domain.solution.cloner.SolutionCloner;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.AlphabeticMemberComparator;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.BeanPropertyMemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.FieldMemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.MethodMemberAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.solution.cloner.FieldAccessingSolutionCloner;
import org.optaplanner.core.impl.domain.solution.cloner.PlanningCloneableSolutionCloner;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionDescriptor {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Class<? extends Solution> solutionClass;
    private SolutionCloner solutionCloner;
    private final Map<String, MemberAccessor> entityPropertyAccessorMap;
    private final Map<String, MemberAccessor> entityCollectionPropertyAccessorMap;
    private final Map<Class<?>, EntityDescriptor> entityDescriptorMap;
    private final List<Class<?>> reversedEntityClassList;
    private final Map<Class<?>, EntityDescriptor> lowestEntityDescriptorCache;

    public static SolutionDescriptor buildSolutionDescriptor(Class<? extends Solution> solutionClass, Class<?> ... entityClasses) {
        return SolutionDescriptor.buildSolutionDescriptor(solutionClass, Arrays.asList(entityClasses));
    }

    public static SolutionDescriptor buildSolutionDescriptor(Class<? extends Solution> solutionClass, List<Class<?>> entityClassList) {
        DescriptorPolicy descriptorPolicy = new DescriptorPolicy();
        SolutionDescriptor solutionDescriptor = new SolutionDescriptor(solutionClass);
        solutionDescriptor.processAnnotations(descriptorPolicy);
        for (Class<?> entityClass : SolutionDescriptor.sortEntityClassList(entityClassList)) {
            EntityDescriptor entityDescriptor = new EntityDescriptor(solutionDescriptor, entityClass);
            solutionDescriptor.addEntityDescriptor(entityDescriptor);
            entityDescriptor.processAnnotations(descriptorPolicy);
        }
        solutionDescriptor.afterAnnotationsProcessed(descriptorPolicy);
        return solutionDescriptor;
    }

    private static List<Class<?>> sortEntityClassList(List<Class<?>> entityClassList) {
        ArrayList sortedEntityClassList = new ArrayList(entityClassList.size());
        for (Class<?> entityClass : entityClassList) {
            boolean added = false;
            for (int i = 0; i < sortedEntityClassList.size(); ++i) {
                Class sortedEntityClass = (Class)sortedEntityClassList.get(i);
                if (!entityClass.isAssignableFrom(sortedEntityClass)) continue;
                sortedEntityClassList.add(i, entityClass);
                added = true;
                break;
            }
            if (added) continue;
            sortedEntityClassList.add(entityClass);
        }
        return sortedEntityClassList;
    }

    public SolutionDescriptor(Class<? extends Solution> solutionClass) {
        this.solutionClass = solutionClass;
        this.entityPropertyAccessorMap = new LinkedHashMap<String, MemberAccessor>();
        this.entityCollectionPropertyAccessorMap = new LinkedHashMap<String, MemberAccessor>();
        this.entityDescriptorMap = new LinkedHashMap();
        this.reversedEntityClassList = new ArrayList();
        this.lowestEntityDescriptorCache = new HashMap();
    }

    public void addEntityDescriptor(EntityDescriptor entityDescriptor) {
        Class<?> entityClass = entityDescriptor.getEntityClass();
        for (Class<?> otherEntityClass : this.entityDescriptorMap.keySet()) {
            if (!entityClass.isAssignableFrom(otherEntityClass)) continue;
            throw new IllegalArgumentException("An earlier entityClass (" + otherEntityClass + ") should not be a subclass of a later entityClass (" + entityClass + "). Switch their declaration so superclasses are defined earlier.");
        }
        this.entityDescriptorMap.put(entityClass, entityDescriptor);
        this.reversedEntityClassList.add(0, entityClass);
        this.lowestEntityDescriptorCache.put(entityClass, entityDescriptor);
    }

    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        this.processSolutionAnnotations(descriptorPolicy);
        this.processValueRangeProviderAnnotations(descriptorPolicy);
        this.processEntityPropertyAnnotations(descriptorPolicy);
    }

    private void processSolutionAnnotations(DescriptorPolicy descriptorPolicy) {
        PlanningSolution solutionAnnotation = this.solutionClass.getAnnotation(PlanningSolution.class);
        if (solutionAnnotation == null) {
            throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has been specified as a solution in the configuration," + " but does not have a " + PlanningSolution.class.getSimpleName() + " annotation.");
        }
        this.processSolutionCloner(descriptorPolicy, solutionAnnotation);
    }

    private void processSolutionCloner(DescriptorPolicy descriptorPolicy, PlanningSolution solutionAnnotation) {
        Class<? extends SolutionCloner> solutionClonerClass = solutionAnnotation.solutionCloner();
        if (solutionClonerClass == PlanningSolution.NullSolutionCloner.class) {
            solutionClonerClass = null;
        }
        this.solutionCloner = solutionClonerClass != null ? ConfigUtils.newInstance(this, "solutionClonerClass", solutionClonerClass) : (PlanningCloneable.class.isAssignableFrom(this.solutionClass) ? new PlanningCloneableSolutionCloner() : new FieldAccessingSolutionCloner(this));
    }

    private void processValueRangeProviderAnnotations(DescriptorPolicy descriptorPolicy) {
        List<Field> fieldList = Arrays.asList(this.solutionClass.getDeclaredFields());
        Collections.sort(fieldList, new AlphabeticMemberComparator());
        for (Field field : fieldList) {
            if (!field.isAnnotationPresent(ValueRangeProvider.class)) continue;
            FieldMemberAccessor memberAccessor = new FieldMemberAccessor(field);
            descriptorPolicy.addFromSolutionValueRangeProvider(memberAccessor);
        }
        List<Method> methodList = Arrays.asList(this.solutionClass.getDeclaredMethods());
        Collections.sort(methodList, new AlphabeticMemberComparator());
        for (Method method : methodList) {
            if (!method.isAnnotationPresent(ValueRangeProvider.class)) continue;
            ReflectionHelper.assertReadMethod(method, ValueRangeProvider.class);
            MethodMemberAccessor memberAccessor = new MethodMemberAccessor(method);
            descriptorPolicy.addFromSolutionValueRangeProvider(memberAccessor);
        }
    }

    private void processEntityPropertyAnnotations(DescriptorPolicy descriptorPolicy) {
        boolean noEntityPropertyAnnotation = true;
        List<Field> fieldList = Arrays.asList(this.solutionClass.getDeclaredFields());
        Collections.sort(fieldList, new AlphabeticMemberComparator());
        for (Field field : fieldList) {
            Class<? extends Annotation> entityPropertyAnnotationClass = this.extractEntityPropertyAnnotationClass(field);
            if (entityPropertyAnnotationClass == null) continue;
            noEntityPropertyAnnotation = false;
            FieldMemberAccessor memberAccessor = new FieldMemberAccessor(field);
            this.registerEntityPropertyAccessor(entityPropertyAnnotationClass, memberAccessor);
        }
        List<Method> methodList = Arrays.asList(this.solutionClass.getDeclaredMethods());
        Collections.sort(methodList, new AlphabeticMemberComparator());
        for (Method method : methodList) {
            Class<? extends Annotation> entityPropertyAnnotationClass = this.extractEntityPropertyAnnotationClass(method);
            if (entityPropertyAnnotationClass == null) continue;
            noEntityPropertyAnnotation = false;
            ReflectionHelper.assertGetterMethod(method, entityPropertyAnnotationClass);
            BeanPropertyMemberAccessor memberAccessor = new BeanPropertyMemberAccessor(method);
            this.registerEntityPropertyAccessor(entityPropertyAnnotationClass, memberAccessor);
        }
        if (noEntityPropertyAnnotation) {
            throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") should have at least 1 getter with a PlanningEntityCollection or PlanningEntityProperty" + " annotation.");
        }
    }

    private Class<? extends Annotation> extractEntityPropertyAnnotationClass(AnnotatedElement member) {
        Class annotationClass = null;
        for (Class detectedAnnotationClass : Arrays.asList(PlanningEntityProperty.class, PlanningEntityCollectionProperty.class)) {
            if (!member.isAnnotationPresent(detectedAnnotationClass)) continue;
            if (annotationClass != null) {
                throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has a member (" + member + ") that has both a " + annotationClass.getSimpleName() + " annotation and a " + detectedAnnotationClass.getSimpleName() + " annotation.");
            }
            annotationClass = detectedAnnotationClass;
        }
        return annotationClass;
    }

    private void registerEntityPropertyAccessor(Class<? extends Annotation> entityPropertyAnnotationClass, MemberAccessor memberAccessor) {
        String memberName = memberAccessor.getName();
        if (this.entityPropertyAccessorMap.containsKey(memberName) || this.entityCollectionPropertyAccessorMap.containsKey(memberName)) {
            MemberAccessor duplicate = this.entityPropertyAccessorMap.get(memberName);
            if (duplicate == null) {
                duplicate = this.entityCollectionPropertyAccessorMap.get(memberName);
            }
            throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has a " + entityPropertyAnnotationClass.getSimpleName() + " annotated member (" + memberAccessor + ") that is duplicated by another member (" + duplicate + ").\n" + "  Verify that the annotation is not defined on both the field and its getter.");
        }
        if (entityPropertyAnnotationClass.equals(PlanningEntityProperty.class)) {
            this.entityPropertyAccessorMap.put(memberName, memberAccessor);
        } else if (entityPropertyAnnotationClass.equals(PlanningEntityCollectionProperty.class)) {
            if (!Collection.class.isAssignableFrom(memberAccessor.getType())) {
                throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has a " + PlanningEntityCollectionProperty.class.getSimpleName() + " annotated member (" + memberName + ") that does not return a " + Collection.class.getSimpleName() + ".");
            }
            this.entityCollectionPropertyAccessorMap.put(memberName, memberAccessor);
        }
    }

    public void afterAnnotationsProcessed(DescriptorPolicy descriptorPolicy) {
        for (EntityDescriptor entityDescriptor : this.entityDescriptorMap.values()) {
            entityDescriptor.linkInheritedEntityDescriptors(descriptorPolicy);
        }
        for (EntityDescriptor entityDescriptor : this.entityDescriptorMap.values()) {
            entityDescriptor.linkShadowSources(descriptorPolicy);
        }
        this.determineGlobalShadowOrder();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("    Model annotations parsed for Solution {}:", (Object)this.solutionClass.getSimpleName());
            for (Map.Entry entry : this.entityDescriptorMap.entrySet()) {
                EntityDescriptor entityDescriptor = (EntityDescriptor)entry.getValue();
                this.logger.trace("        Entity {}:", (Object)entityDescriptor.getEntityClass().getSimpleName());
                for (VariableDescriptor variableDescriptor : entityDescriptor.getDeclaredVariableDescriptors()) {
                    this.logger.trace("            Variable {} ({})", (Object)variableDescriptor.getVariableName(), (Object)(variableDescriptor instanceof GenuineVariableDescriptor ? "genuine" : "shadow"));
                }
            }
        }
    }

    private void determineGlobalShadowOrder() {
        LinkedList<ShadowVariableDescriptor> orderedShadowList = new LinkedList<ShadowVariableDescriptor>();
        for (EntityDescriptor entityDescriptor : this.entityDescriptorMap.values()) {
            for (ShadowVariableDescriptor shadow : entityDescriptor.getDeclaredShadowVariableDescriptors()) {
                Integer insertionIndex = null;
                ListIterator it = orderedShadowList.listIterator();
                while (it.hasNext()) {
                    int index = it.nextIndex();
                    ShadowVariableDescriptor orderedShadow = (ShadowVariableDescriptor)it.next();
                    if (insertionIndex == null && orderedShadow.getSourceVariableDescriptorList().contains(shadow)) {
                        insertionIndex = index;
                    }
                    if (insertionIndex == null || !shadow.getSourceVariableDescriptorList().contains(orderedShadow)) continue;
                    ShadowVariableDescriptor otherOrderedShadow = (ShadowVariableDescriptor)orderedShadowList.get(insertionIndex);
                    throw new IllegalStateException("There is a cyclic shadow variable path because the shadowVariable (" + shadow.getSimpleEntityAndVariableName() + ") must be earlier than (" + otherOrderedShadow.getSimpleEntityAndVariableName() + ") but later than (" + orderedShadow.getSimpleEntityAndVariableName() + ").");
                }
                if (insertionIndex != null) {
                    orderedShadowList.add(insertionIndex, shadow);
                    continue;
                }
                orderedShadowList.add(shadow);
            }
        }
        ListIterator it = orderedShadowList.listIterator();
        while (it.hasNext()) {
            int index = it.nextIndex();
            ShadowVariableDescriptor orderedShadow = (ShadowVariableDescriptor)it.next();
            orderedShadow.setGlobalShadowOrder(index);
        }
    }

    public Class<? extends Solution> getSolutionClass() {
        return this.solutionClass;
    }

    public Class<? extends Score> extractScoreClass() {
        try {
            return this.solutionClass.getMethod("getScore", new Class[0]).getReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Impossible situation: a solutionClass (" + this.solutionClass + ") which implements the interface Solution, lacks its getScore() method.", e);
        }
    }

    public SolutionCloner getSolutionCloner() {
        return this.solutionCloner;
    }

    public Map<String, MemberAccessor> getEntityPropertyAccessorMap() {
        return this.entityPropertyAccessorMap;
    }

    public Map<String, MemberAccessor> getEntityCollectionPropertyAccessorMap() {
        return this.entityCollectionPropertyAccessorMap;
    }

    public Set<Class<?>> getEntityClassSet() {
        return this.entityDescriptorMap.keySet();
    }

    public Collection<EntityDescriptor> getEntityDescriptors() {
        return this.entityDescriptorMap.values();
    }

    public Collection<EntityDescriptor> getGenuineEntityDescriptors() {
        ArrayList<EntityDescriptor> genuineEntityDescriptorList = new ArrayList<EntityDescriptor>(this.entityDescriptorMap.size());
        for (EntityDescriptor entityDescriptor : this.entityDescriptorMap.values()) {
            if (!entityDescriptor.hasAnyDeclaredGenuineVariableDescriptor()) continue;
            genuineEntityDescriptorList.add(entityDescriptor);
        }
        return genuineEntityDescriptorList;
    }

    public boolean hasEntityDescriptorStrict(Class<?> entityClass) {
        return this.entityDescriptorMap.containsKey(entityClass);
    }

    public EntityDescriptor getEntityDescriptorStrict(Class<?> entityClass) {
        return this.entityDescriptorMap.get(entityClass);
    }

    public boolean hasEntityDescriptor(Class<?> entitySubclass) {
        EntityDescriptor entityDescriptor = this.findEntityDescriptor(entitySubclass);
        return entityDescriptor != null;
    }

    public EntityDescriptor findEntityDescriptorOrFail(Class<?> entitySubclass) {
        EntityDescriptor entityDescriptor = this.findEntityDescriptor(entitySubclass);
        if (entityDescriptor == null) {
            throw new IllegalArgumentException("A planning entity is an instance of an entitySubclass (" + entitySubclass + ") that is not configured as a planning entity.\n" + "If that class (" + entitySubclass.getSimpleName() + ") (or superclass thereof) is not a entityClass (" + this.getEntityClassSet() + "), check your Solution implementation's annotated methods.\n" + "If it is, check your solver configuration.");
        }
        return entityDescriptor;
    }

    public EntityDescriptor findEntityDescriptor(Class<?> entitySubclass) {
        EntityDescriptor entityDescriptor = this.lowestEntityDescriptorCache.get(entitySubclass);
        if (entityDescriptor == null) {
            for (Class<?> entityClass : this.reversedEntityClassList) {
                if (!entityClass.isAssignableFrom(entitySubclass)) continue;
                entityDescriptor = this.entityDescriptorMap.get(entityClass);
                this.lowestEntityDescriptorCache.put(entitySubclass, entityDescriptor);
                break;
            }
        }
        return entityDescriptor;
    }

    public GenuineVariableDescriptor findGenuineVariableDescriptor(Object entity, String variableName) {
        EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
        return entityDescriptor.getGenuineVariableDescriptor(variableName);
    }

    public GenuineVariableDescriptor findGenuineVariableDescriptorOrFail(Object entity, String variableName) {
        EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
        GenuineVariableDescriptor variableDescriptor = entityDescriptor.getGenuineVariableDescriptor(variableName);
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(entityDescriptor.buildInvalidVariableNameExceptionMessage(variableName));
        }
        return variableDescriptor;
    }

    public VariableDescriptor findVariableDescriptor(Object entity, String variableName) {
        EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
        return entityDescriptor.getVariableDescriptor(variableName);
    }

    public VariableDescriptor findVariableDescriptorOrFail(Object entity, String variableName) {
        EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
        VariableDescriptor variableDescriptor = entityDescriptor.getVariableDescriptor(variableName);
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(entityDescriptor.buildInvalidVariableNameExceptionMessage(variableName));
        }
        return variableDescriptor;
    }

    public Collection<Object> getAllFacts(Solution solution) {
        ArrayList<Object> facts = new ArrayList<Object>();
        Collection<Object> problemFacts = solution.getProblemFacts();
        if (problemFacts == null) {
            throw new IllegalStateException("The solution (" + solution + ")'s method getProblemFacts() should never return null.");
        }
        facts.addAll(problemFacts);
        for (MemberAccessor entityMemberAccessor : this.entityPropertyAccessorMap.values()) {
            Object entity = this.extractEntity(entityMemberAccessor, solution);
            if (entity == null) continue;
            facts.add(entity);
        }
        for (MemberAccessor entityCollectionMemberAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<Object> entityCollection = this.extractEntityCollection(entityCollectionMemberAccessor, solution);
            facts.addAll(entityCollection);
        }
        return facts;
    }

    public int getEntityCount(Solution solution) {
        int entityCount = 0;
        for (MemberAccessor entityMemberAccessor : this.entityPropertyAccessorMap.values()) {
            Object entity = this.extractEntity(entityMemberAccessor, solution);
            if (entity == null) continue;
            ++entityCount;
        }
        for (MemberAccessor entityCollectionMemberAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<Object> entityCollection = this.extractEntityCollection(entityCollectionMemberAccessor, solution);
            entityCount += entityCollection.size();
        }
        return entityCount;
    }

    public List<Object> getEntityList(Solution solution) {
        ArrayList<Object> entityList = new ArrayList<Object>();
        for (MemberAccessor entityMemberAccessor : this.entityPropertyAccessorMap.values()) {
            Object entity = this.extractEntity(entityMemberAccessor, solution);
            if (entity == null) continue;
            entityList.add(entity);
        }
        for (MemberAccessor entityCollectionMemberAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<Object> entityCollection = this.extractEntityCollection(entityCollectionMemberAccessor, solution);
            entityList.addAll(entityCollection);
        }
        return entityList;
    }

    public List<Object> getEntityListByEntityClass(Solution solution, Class<?> entityClass) {
        ArrayList<Object> entityList = new ArrayList<Object>();
        for (MemberAccessor entityMemberAccessor : this.entityPropertyAccessorMap.values()) {
            Object entity;
            if (!entityMemberAccessor.getType().isAssignableFrom(entityClass) || (entity = this.extractEntity(entityMemberAccessor, solution)) == null || !entityClass.isInstance(entity)) continue;
            entityList.add(entity);
        }
        for (MemberAccessor entityCollectionMemberAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<Object> entityCollection = this.extractEntityCollection(entityCollectionMemberAccessor, solution);
            for (Object entity : entityCollection) {
                if (!entityClass.isInstance(entity)) continue;
                entityList.add(entity);
            }
        }
        return entityList;
    }

    public long getGenuineVariableCount(Solution solution) {
        long variableCount = 0L;
        Iterator<Object> it = this.extractAllEntitiesIterator(solution);
        while (it.hasNext()) {
            Object entity = it.next();
            EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
            variableCount += entityDescriptor.getGenuineVariableCount();
        }
        return variableCount;
    }

    public int getValueCount(Solution solution) {
        boolean valueCount = false;
        throw new UnsupportedOperationException("getValueCount is not yet supported - this blocks ValueRatioTabuSizeStrategy");
    }

    public long getProblemScale(Solution solution) {
        long problemScale = 0L;
        Iterator<Object> it = this.extractAllEntitiesIterator(solution);
        while (it.hasNext()) {
            Object entity = it.next();
            EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
            problemScale += entityDescriptor.getProblemScale(solution, entity);
        }
        return problemScale;
    }

    public int countUninitializedVariables(Solution solution) {
        int count = 0;
        Iterator<Object> it = this.extractAllEntitiesIterator(solution);
        while (it.hasNext()) {
            Object entity = it.next();
            EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
            count += entityDescriptor.countUninitializedVariables(entity);
        }
        return count;
    }

    public boolean isEntityInitializedOrImmovable(ScoreDirector scoreDirector, Object entity) {
        EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
        return entityDescriptor.isInitialized(entity) || !entityDescriptor.isMovable(scoreDirector, entity);
    }

    public int countReinitializableVariables(ScoreDirector scoreDirector, Solution solution) {
        int count = 0;
        Iterator<Object> it = this.extractAllEntitiesIterator(solution);
        while (it.hasNext()) {
            Object entity = it.next();
            EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
            count += entityDescriptor.countReinitializableVariables(scoreDirector, entity);
        }
        return count;
    }

    public Iterator<Object> extractAllEntitiesIterator(Solution solution) {
        ArrayList<Iterator<Object>> iteratorList = new ArrayList<Iterator<Object>>(this.entityPropertyAccessorMap.size() + this.entityCollectionPropertyAccessorMap.size());
        for (MemberAccessor entityMemberAccessor : this.entityPropertyAccessorMap.values()) {
            Object entity = this.extractEntity(entityMemberAccessor, solution);
            if (entity == null) continue;
            iteratorList.add(Collections.singletonList(entity).iterator());
        }
        for (MemberAccessor entityCollectionMemberAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<Object> entityCollection = this.extractEntityCollection(entityCollectionMemberAccessor, solution);
            iteratorList.add(entityCollection.iterator());
        }
        return Iterators.concat(iteratorList.iterator());
    }

    private Object extractEntity(MemberAccessor entityMemberAccessor, Solution solution) {
        return entityMemberAccessor.executeGetter(solution);
    }

    private Collection<Object> extractEntityCollection(MemberAccessor entityCollectionMemberAccessor, Solution solution) {
        Collection entityCollection = (Collection)entityCollectionMemberAccessor.executeGetter(solution);
        if (entityCollection == null) {
            throw new IllegalArgumentException("The solutionClass (" + this.solutionClass + ")'s entityCollectionProperty (" + entityCollectionMemberAccessor.getName() + ") should never return null.");
        }
        return entityCollection;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.solutionClass.getName() + ")";
    }
}

