/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.move;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.move.NoChangeMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class CompositeMove
implements Move {
    protected final Move[] moves;

    public static Move buildMove(Move ... moves) {
        int size = moves.length;
        if (size > 1) {
            return new CompositeMove(moves);
        }
        if (size == 1) {
            return moves[0];
        }
        return new NoChangeMove();
    }

    public static Move buildMove(List<Move> moveList) {
        int size = moveList.size();
        if (size > 1) {
            return new CompositeMove(moveList.toArray(new Move[moveList.size()]));
        }
        if (size == 1) {
            return moveList.get(0);
        }
        return new NoChangeMove();
    }

    public CompositeMove(Move ... moves) {
        this.moves = moves;
    }

    public Move[] getMoves() {
        return this.moves;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        for (Move move : this.moves) {
            if (move.isMoveDoable(scoreDirector)) continue;
            return false;
        }
        return true;
    }

    @Override
    public CompositeMove createUndoMove(ScoreDirector scoreDirector) {
        Move[] undoMoves = new Move[this.moves.length];
        for (int i = 0; i < this.moves.length; ++i) {
            Move undoMove;
            undoMoves[this.moves.length - 1 - i] = undoMove = this.moves[i].createUndoMove(scoreDirector);
        }
        return new CompositeMove(undoMoves);
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        for (Move move : this.moves) {
            move.doMove(scoreDirector);
        }
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        TreeSet<String> childMoveTypeDescriptionSet = new TreeSet<String>();
        for (Move move : this.moves) {
            childMoveTypeDescriptionSet.add(move.getSimpleMoveTypeDescription());
        }
        StringBuilder moveTypeDescription = new StringBuilder(20 * (this.moves.length + 1));
        moveTypeDescription.append(this.getClass().getSimpleName()).append("(");
        String delimiter = "";
        for (String childMoveTypeDescription : childMoveTypeDescriptionSet) {
            moveTypeDescription.append(delimiter).append("* ").append(childMoveTypeDescription);
            delimiter = ", ";
        }
        moveTypeDescription.append(")");
        return moveTypeDescription.toString();
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        LinkedHashSet<? extends Object> entities = new LinkedHashSet<Object>(this.moves.length * 2);
        for (Move move : this.moves) {
            entities.addAll(move.getPlanningEntities());
        }
        return entities;
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        LinkedHashSet<? extends Object> values = new LinkedHashSet<Object>(this.moves.length * 2);
        for (Move move : this.moves) {
            values.addAll(move.getPlanningValues());
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CompositeMove) {
            CompositeMove other = (CompositeMove)o;
            return Arrays.equals(this.moves, other.moves);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.moves);
    }

    public String toString() {
        return Arrays.toString(this.moves);
    }
}

