/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.decorator;

import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class WeightFactorySelectionSorter<T>
implements SelectionSorter<T> {
    private final SelectionSorterWeightFactory<Solution, T> selectionSorterWeightFactory;
    private final Comparator<Comparable> appliedWeightComparator;

    public WeightFactorySelectionSorter(SelectionSorterWeightFactory<Solution, T> selectionSorterWeightFactory, SelectionSorterOrder selectionSorterOrder) {
        this.selectionSorterWeightFactory = selectionSorterWeightFactory;
        switch (selectionSorterOrder) {
            case ASCENDING: {
                this.appliedWeightComparator = Ordering.natural();
                break;
            }
            case DESCENDING: {
                this.appliedWeightComparator = Collections.reverseOrder();
                break;
            }
            default: {
                throw new IllegalStateException("The selectionSorterOrder (" + (Object)((Object)selectionSorterOrder) + ") is not implemented.");
            }
        }
    }

    @Override
    public void sort(ScoreDirector scoreDirector, List<T> selectionList) {
        Solution solution = scoreDirector.getWorkingSolution();
        TreeMap<Comparable, T> selectionMap = new TreeMap<Comparable, T>(this.appliedWeightComparator);
        for (T selection : selectionList) {
            Comparable difficultyWeight = this.selectionSorterWeightFactory.createSorterWeight(solution, selection);
            T previous = selectionMap.put(difficultyWeight, selection);
            if (previous == null) continue;
            throw new IllegalStateException("The selectionList contains 2 times the same selection (" + previous + ") and (" + selection + ").");
        }
        selectionList.clear();
        selectionList.addAll(selectionMap.values());
    }
}

