/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.nearby;

import java.util.Random;
import org.apache.commons.math3.distribution.BetaDistribution;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;

public class BetaDistributionNearbyRandom
implements NearbyRandom {
    protected final BetaDistribution betaDistribution;

    public BetaDistributionNearbyRandom(double betaDistributionAlpha, double betaDistributionBeta) {
        if (betaDistributionAlpha <= 0.0) {
            throw new IllegalArgumentException("The betaDistributionAlpha (" + betaDistributionAlpha + ") must be greater than 0.");
        }
        if (betaDistributionBeta <= 0.0) {
            throw new IllegalArgumentException("The betaDistributionBeta (" + betaDistributionBeta + ") must be greater than 0.");
        }
        this.betaDistribution = new BetaDistribution(betaDistributionAlpha, betaDistributionBeta);
    }

    @Override
    public int nextInt(Random random, int nearbySize) {
        double d = this.betaDistribution.inverseCumulativeProbability(random.nextDouble());
        int next = (int)(d * (double)nearbySize);
        if (next >= nearbySize) {
            next = nearbySize - 1;
        }
        return next;
    }
}

