/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.nearby;

import java.util.Random;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;

public class LinearDistributionNearbyRandom
implements NearbyRandom {
    protected final int sizeMaximum;

    public LinearDistributionNearbyRandom(int sizeMaximum) {
        this.sizeMaximum = sizeMaximum;
        if (sizeMaximum < 1) {
            throw new IllegalArgumentException("The maximum (" + sizeMaximum + ") must be at least 1.");
        }
    }

    @Override
    public int nextInt(Random random, int nearbySize) {
        double p;
        int m = this.sizeMaximum <= nearbySize ? this.sizeMaximum : nearbySize;
        double x = (double)m * (1.0 - Math.sqrt(1.0 - (p = random.nextDouble())));
        int next = (int)x;
        if (next >= m) {
            next = m - 1;
        }
        return next;
    }
}

