/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.awt.Component;
import org.optaplanner.benchmark.impl.aggregator.swingui.SwingUncaughtExceptionHandler;
import org.optaplanner.benchmark.impl.aggregator.swingui.SwingUtils;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.common.business.SolutionBusiness;
import org.optaplanner.examples.common.persistence.AbstractSolutionExporter;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionDao;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.SolverAndPersistenceFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonApp
extends LoggingMain {
    protected static final Logger logger = LoggerFactory.getLogger(CommonApp.class);
    protected final String name;
    protected final String description;
    protected final String iconResource;
    protected SolverAndPersistenceFrame solverAndPersistenceFrame;
    protected SolutionBusiness solutionBusiness;

    public static void prepareSwingEnvironment() {
        SwingUncaughtExceptionHandler.register();
        SwingUtils.fixateLookAndFeel();
    }

    protected CommonApp(String name, String description, String iconResource) {
        this.name = name;
        this.description = description;
        this.iconResource = iconResource;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIconResource() {
        return this.iconResource;
    }

    public void init() {
        this.init(null, true);
    }

    public void init(Component centerForComponent, boolean exitOnClose) {
        this.solutionBusiness = this.createSolutionBusiness();
        this.solverAndPersistenceFrame = new SolverAndPersistenceFrame(this.solutionBusiness, this.createSolutionPanel());
        this.solverAndPersistenceFrame.setDefaultCloseOperation(exitOnClose ? 3 : 2);
        this.solverAndPersistenceFrame.init(centerForComponent);
        this.solverAndPersistenceFrame.setVisible(true);
    }

    public SolutionBusiness createSolutionBusiness() {
        SolutionBusiness solutionBusiness = new SolutionBusiness(this);
        solutionBusiness.setSolutionDao(this.createSolutionDao());
        solutionBusiness.setImporters(this.createSolutionImporters());
        solutionBusiness.setExporter(this.createSolutionExporter());
        solutionBusiness.updateDataDirs();
        solutionBusiness.setSolver(this.createSolver());
        return solutionBusiness;
    }

    protected abstract Solver createSolver();

    protected abstract SolutionPanel createSolutionPanel();

    protected abstract SolutionDao createSolutionDao();

    protected AbstractSolutionImporter[] createSolutionImporters() {
        return new AbstractSolutionImporter[0];
    }

    protected AbstractSolutionExporter createSolutionExporter() {
        return null;
    }
}

