/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.swingui.latitudelongitude;

import java.awt.Graphics2D;
import java.awt.geom.CubicCurve2D;
import org.optaplanner.examples.common.swingui.TangoColorFactory;

public class LatitudeLongitudeTranslator {
    public static final double MARGIN_RATIO = 0.04;
    private double minimumLatitude = Double.MAX_VALUE;
    private double maximumLatitude = -1.7976931348623157E308;
    private double minimumLongitude = Double.MAX_VALUE;
    private double maximumLongitude = -1.7976931348623157E308;
    private double latitudeLength = 0.0;
    private double longitudeLength = 0.0;
    private double innerWidth = 0.0;
    private double innerHeight = 0.0;
    private double innerWidthMargin = 0.0;
    private double innerHeightMargin = 0.0;
    private int imageWidth = -1;
    private int imageHeight = -1;

    public void addCoordinates(double latitude, double longitude) {
        if (latitude < this.minimumLatitude) {
            this.minimumLatitude = latitude;
        }
        if (latitude > this.maximumLatitude) {
            this.maximumLatitude = latitude;
        }
        if (longitude < this.minimumLongitude) {
            this.minimumLongitude = longitude;
        }
        if (longitude > this.maximumLongitude) {
            this.maximumLongitude = longitude;
        }
    }

    public void prepareFor(double width, double height) {
        this.latitudeLength = this.maximumLatitude - this.minimumLatitude;
        this.longitudeLength = this.maximumLongitude - this.minimumLongitude;
        this.innerWidthMargin = width * 0.04;
        this.innerHeightMargin = height * 0.04;
        this.innerWidth = width - 2.0 * this.innerWidthMargin;
        this.innerHeight = height - 2.0 * this.innerHeightMargin;
        if (this.innerWidth > this.innerHeight * this.longitudeLength / this.latitudeLength) {
            this.innerWidth = this.innerHeight * this.longitudeLength / this.latitudeLength;
        } else {
            this.innerHeight = this.innerWidth * this.latitudeLength / this.longitudeLength;
        }
        this.imageWidth = (int)Math.floor(2.0 * this.innerWidthMargin + this.innerWidth);
        this.imageHeight = (int)Math.floor(2.0 * this.innerHeightMargin + this.innerHeight);
    }

    public int translateLongitudeToX(double longitude) {
        return (int)Math.floor((longitude - this.minimumLongitude) * this.innerWidth / this.longitudeLength + this.innerWidthMargin);
    }

    public int translateLatitudeToY(double latitude) {
        return (int)Math.floor((this.maximumLatitude - latitude) * this.innerHeight / this.latitudeLength + this.innerHeightMargin);
    }

    public double translateXToLongitude(int x) {
        return this.minimumLongitude + ((double)x - this.innerWidthMargin) * this.longitudeLength / this.innerWidth;
    }

    public double translateYToLatitude(double y) {
        return this.maximumLatitude - (y - this.innerHeightMargin) * this.latitudeLength / this.innerHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void drawSquare(Graphics2D g, double lon, double lat, int diameter) {
        this.drawSquare(g, lon, lat, diameter, null);
    }

    public void drawSquare(Graphics2D g, double lon, double lat, int diameter, String label) {
        int x = this.translateLongitudeToX(lon);
        int y = this.translateLatitudeToY(lat);
        g.fillRect(x - diameter / 2, y - diameter / 2, diameter, diameter);
        if (label != null) {
            g.drawString(label, x + diameter, y - diameter);
        }
    }

    public void drawRoute(Graphics2D g, double lon1, double lat1, double lon2, double lat2, boolean straight, boolean dashed) {
        int x1 = this.translateLongitudeToX(lon1);
        int y1 = this.translateLatitudeToY(lat1);
        int x2 = this.translateLongitudeToX(lon2);
        int y2 = this.translateLatitudeToY(lat2);
        if (dashed) {
            g.setStroke(TangoColorFactory.FAT_DASHED_STROKE);
        }
        if (straight) {
            g.drawLine(x1, y1, x2, y2);
        } else {
            double xDistPart = (double)(x2 - x1) / 3.0;
            double yDistPart = (double)(y2 - y1) / 3.0;
            double ctrlx1 = (double)x1 + xDistPart + yDistPart;
            double ctrly1 = (double)y1 - xDistPart + yDistPart;
            double ctrlx2 = (double)x2 - xDistPart - yDistPart;
            double ctrly2 = (double)y2 + xDistPart - yDistPart;
            g.draw(new CubicCurve2D.Double(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2));
        }
        if (dashed) {
            g.setStroke(TangoColorFactory.NORMAL_STROKE);
        }
    }
}

