/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.xstream.impl.domain.solution;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public class XStreamSolutionFileIO
implements SolutionFileIO {
    public static final String FILE_EXTENSION = "xml";
    private XStream xStream = new XStream();

    public XStreamSolutionFileIO() {
        this.xStream.setMode(1002);
    }

    public XStreamSolutionFileIO(Class ... xStreamAnnotatedClasses) {
        this();
        this.xStream.processAnnotations(xStreamAnnotatedClasses);
    }

    public String getInputFileExtension() {
        return FILE_EXTENSION;
    }

    public String getOutputFileExtension() {
        return FILE_EXTENSION;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Solution read(File inputSolutionFile) {
        Solution unsolvedSolution;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(inputSolutionFile), "UTF-8");
            unsolvedSolution = (Solution)this.xStream.fromXML((Reader)reader);
        }
        catch (XStreamException e) {
            try {
                throw new IllegalArgumentException("Problem reading inputSolutionFile (" + inputSolutionFile + ").", e);
                catch (IOException e2) {
                    throw new IllegalArgumentException("Problem reading inputSolutionFile (" + inputSolutionFile + ").", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return unsolvedSolution;
    }

    public void write(Solution solution, File outputSolutionFile) {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputSolutionFile), "UTF-8");
            this.xStream.toXML((Object)solution, (Writer)writer);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing outputSolutionFile (" + outputSolutionFile + ").", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }
}

