/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.move.generic.chained;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.MoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.value.ValueSelectorConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.KOptMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;

@XStreamAlias(value="kOptMoveSelector")
public class KOptMoveSelectorConfig
extends MoveSelectorConfig<KOptMoveSelectorConfig> {
    public static final int K = 3;
    @XStreamAlias(value="entitySelector")
    private EntitySelectorConfig entitySelectorConfig = null;
    @XStreamAlias(value="valueSelector")
    private ValueSelectorConfig valueSelectorConfig = null;

    public EntitySelectorConfig getEntitySelectorConfig() {
        return this.entitySelectorConfig;
    }

    public void setEntitySelectorConfig(EntitySelectorConfig entitySelectorConfig) {
        this.entitySelectorConfig = entitySelectorConfig;
    }

    public ValueSelectorConfig getValueSelectorConfig() {
        return this.valueSelectorConfig;
    }

    public void setValueSelectorConfig(ValueSelectorConfig valueSelectorConfig) {
        this.valueSelectorConfig = valueSelectorConfig;
    }

    @Override
    public MoveSelector buildBaseMoveSelector(HeuristicConfigPolicy configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        EntitySelectorConfig entitySelectorConfig_ = this.entitySelectorConfig == null ? new EntitySelectorConfig() : this.entitySelectorConfig;
        EntitySelector entitySelector = entitySelectorConfig_.buildEntitySelector(configPolicy, minimumCacheType, SelectionOrder.fromRandomSelectionBoolean(randomSelection));
        ValueSelectorConfig valueSelectorConfig_ = this.valueSelectorConfig == null ? new ValueSelectorConfig() : this.valueSelectorConfig;
        ValueSelector[] valueSelectors = new ValueSelector[2];
        for (int i = 0; i < valueSelectors.length; ++i) {
            valueSelectors[i] = valueSelectorConfig_.buildValueSelector(configPolicy, entitySelector.getEntityDescriptor(), minimumCacheType, SelectionOrder.fromRandomSelectionBoolean(randomSelection));
        }
        return new KOptMoveSelector(entitySelector, valueSelectors, randomSelection);
    }

    @Override
    public void inherit(KOptMoveSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.entitySelectorConfig = ConfigUtils.inheritConfig(this.entitySelectorConfig, inheritedConfig.getEntitySelectorConfig());
        this.valueSelectorConfig = ConfigUtils.inheritConfig(this.valueSelectorConfig, inheritedConfig.getValueSelectorConfig());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelectorConfig + ", " + this.valueSelectorConfig + ")";
    }
}

