/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningEntityProperty;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;

public abstract class AbstractSolution<S extends Score>
implements Solution<S>,
Serializable {
    protected S score;

    @Override
    public S getScore() {
        return this.score;
    }

    @Override
    public void setScore(S score) {
        this.score = score;
    }

    @Override
    public Collection<?> getProblemFacts() {
        ArrayList<Object> factList = new ArrayList<Object>();
        Class<?> instanceClass = this.getClass();
        this.addProblemFactsFromClass(factList, instanceClass);
        return factList;
    }

    private void addProblemFactsFromClass(List<Object> factList, Class<?> instanceClass) {
        if (instanceClass.equals(AbstractSolution.class)) {
            return;
        }
        for (Field field : instanceClass.getDeclaredFields()) {
            Object value;
            field.setAccessible(true);
            if (this.isFieldAPlanningEntityPropertyOrPlanningEntityCollectionProperty(field, instanceClass)) continue;
            try {
                value = field.get(this);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("The class (" + instanceClass + ") has a field (" + field + ") which can not be read to create the problem facts.", e);
            }
            if (value == null) continue;
            if (value instanceof Collection) {
                factList.addAll((Collection)value);
                continue;
            }
            if (value instanceof Map) {
                throw new IllegalStateException("The class (" + instanceClass + ") has a field (" + field + ") which is a " + Map.class.getSimpleName() + " and that's not yet supported.");
            }
            factList.add(value);
        }
        Class<?> superclass = instanceClass.getSuperclass();
        if (superclass != null) {
            this.addProblemFactsFromClass(factList, superclass);
        }
    }

    private boolean isFieldAPlanningEntityPropertyOrPlanningEntityCollectionProperty(Field field, Class fieldInstanceClass) {
        if (field.isAnnotationPresent(PlanningEntityProperty.class) || field.isAnnotationPresent(PlanningEntityCollectionProperty.class)) {
            return true;
        }
        Method getterMethod = ReflectionHelper.getGetterMethod(fieldInstanceClass, field.getName());
        return getterMethod != null && (getterMethod.isAnnotationPresent(PlanningEntityProperty.class) || getterMethod.isAnnotationPresent(PlanningEntityCollectionProperty.class));
    }
}

