/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.inverserelation;

import java.util.Collection;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.CollectionInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class CollectionInverseVariableListener
implements VariableListener<Object>,
CollectionInverseVariableSupply {
    protected final InverseRelationShadowVariableDescriptor shadowVariableDescriptor;
    protected final VariableDescriptor sourceVariableDescriptor;

    public CollectionInverseVariableListener(InverseRelationShadowVariableDescriptor shadowVariableDescriptor, VariableDescriptor sourceVariableDescriptor) {
        this.shadowVariableDescriptor = shadowVariableDescriptor;
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    @Override
    public void beforeEntityAdded(ScoreDirector scoreDirector, Object entity) {
    }

    @Override
    public void afterEntityAdded(ScoreDirector scoreDirector, Object entity) {
        this.insert(scoreDirector, entity);
    }

    @Override
    public void beforeVariableChanged(ScoreDirector scoreDirector, Object entity) {
        this.retract(scoreDirector, entity);
    }

    @Override
    public void afterVariableChanged(ScoreDirector scoreDirector, Object entity) {
        this.insert(scoreDirector, entity);
    }

    @Override
    public void beforeEntityRemoved(ScoreDirector scoreDirector, Object entity) {
        this.retract(scoreDirector, entity);
    }

    @Override
    public void afterEntityRemoved(ScoreDirector scoreDirector, Object entity) {
    }

    protected void insert(ScoreDirector scoreDirector, Object entity) {
        Object shadowEntity = this.sourceVariableDescriptor.getValue(entity);
        if (shadowEntity != null) {
            Collection shadowCollection = (Collection)this.shadowVariableDescriptor.getValue(shadowEntity);
            if (shadowCollection == null) {
                throw new IllegalStateException("The entity (" + entity + ") has a variable (" + this.sourceVariableDescriptor.getVariableName() + ") with value (" + shadowEntity + ") which has a sourceVariableName variable (" + this.shadowVariableDescriptor.getVariableName() + ") with a value (" + shadowCollection + ") which is null.\n" + "Verify the consistency of your input problem for that bi-directional relationship.\n" + "Every non-singleton inverse variable can never be null. It should at least be an empty " + Collection.class.getSimpleName() + " instead.");
            }
            scoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, shadowEntity);
            boolean added = shadowCollection.add(entity);
            if (!added) {
                throw new IllegalStateException("The entity (" + entity + ") has a variable (" + this.sourceVariableDescriptor.getVariableName() + ") with value (" + shadowEntity + ") which has a sourceVariableName variable (" + this.shadowVariableDescriptor.getVariableName() + ") with a value (" + shadowCollection + ") which already contained the entity (" + entity + ").\n" + "Verify the consistency of your input problem for that bi-directional relationship.");
            }
            scoreDirector.afterVariableChanged(this.shadowVariableDescriptor, shadowEntity);
        }
    }

    protected void retract(ScoreDirector scoreDirector, Object entity) {
        Object shadowEntity = this.sourceVariableDescriptor.getValue(entity);
        if (shadowEntity != null) {
            Collection shadowCollection = (Collection)this.shadowVariableDescriptor.getValue(shadowEntity);
            if (shadowCollection == null) {
                throw new IllegalStateException("The entity (" + entity + ") has a variable (" + this.sourceVariableDescriptor.getVariableName() + ") with value (" + shadowEntity + ") which has a sourceVariableName variable (" + this.shadowVariableDescriptor.getVariableName() + ") with a value (" + shadowCollection + ") which is null.\n" + "Verify the consistency of your input problem for that bi-directional relationship.\n" + "Every non-singleton inverse variable can never be null. It should at least be an empty " + Collection.class.getSimpleName() + " instead.");
            }
            scoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, shadowEntity);
            boolean removed = shadowCollection.remove(entity);
            if (!removed) {
                throw new IllegalStateException("The entity (" + entity + ") has a variable (" + this.sourceVariableDescriptor.getVariableName() + ") with value (" + shadowEntity + ") which has a sourceVariableName variable (" + this.shadowVariableDescriptor.getVariableName() + ") with a value (" + shadowCollection + ") which did not contain the entity (" + entity + ").\n" + "Verify the consistency of your input problem for that bi-directional relationship.");
            }
            scoreDirector.afterVariableChanged(this.shadowVariableDescriptor, shadowEntity);
        }
    }

    @Override
    public Collection<?> getInverseCollection(Object planningValue) {
        return (Collection)this.shadowVariableDescriptor.getValue(planningValue);
    }
}

