/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.pillar.PillarSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.PillarChangeMove;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;

public class PillarChangeMoveSelector
extends GenericMoveSelector {
    protected final PillarSelector pillarSelector;
    protected final ValueSelector valueSelector;
    protected final boolean randomSelection;

    public PillarChangeMoveSelector(PillarSelector pillarSelector, ValueSelector valueSelector, boolean randomSelection) {
        this.pillarSelector = pillarSelector;
        this.valueSelector = valueSelector;
        this.randomSelection = randomSelection;
        GenuineVariableDescriptor variableDescriptor = valueSelector.getVariableDescriptor();
        if (variableDescriptor.isChained()) {
            throw new IllegalStateException("The selector (" + this + ") has a variableDescriptor (" + variableDescriptor + ") which is chained (" + variableDescriptor.isChained() + ").");
        }
        this.phaseLifecycleSupport.addEventListener(pillarSelector);
        this.phaseLifecycleSupport.addEventListener(valueSelector);
    }

    @Override
    public boolean isCountable() {
        return this.pillarSelector.isCountable() && this.valueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.pillarSelector.isNeverEnding() || this.valueSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        if (!(this.valueSelector instanceof EntityIndependentValueSelector)) {
            throw new IllegalArgumentException("To use the method getSize(), the moveSelector (" + this + ") needs to be based on an EntityIndependentValueSelector (" + this.valueSelector + ")." + " Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
        }
        return this.pillarSelector.getSize() * ((EntityIndependentValueSelector)this.valueSelector).getSize();
    }

    @Override
    public Iterator<Move> iterator() {
        if (!this.randomSelection) {
            return new OriginalPillarChangeMoveIterator();
        }
        return new RandomPillarChangeMoveIterator();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.pillarSelector + ", " + this.valueSelector + ")";
    }

    private class RandomPillarChangeMoveIterator
    extends UpcomingSelectionIterator<Move> {
        private Iterator<List<Object>> pillarIterator;
        private Iterator<Object> valueIterator;

        private RandomPillarChangeMoveIterator() {
            this.pillarIterator = PillarChangeMoveSelector.this.pillarSelector.iterator();
            this.valueIterator = Iterators.emptyIterator();
        }

        @Override
        protected Move createUpcomingSelection() {
            if (!this.pillarIterator.hasNext()) {
                this.pillarIterator = PillarChangeMoveSelector.this.pillarSelector.iterator();
                if (!this.pillarIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
            }
            List<Object> pillar = this.pillarIterator.next();
            if (!this.valueIterator.hasNext()) {
                this.valueIterator = PillarChangeMoveSelector.this.valueSelector.iterator(pillar.get(0));
                if (!this.valueIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
            }
            Object toValue = this.valueIterator.next();
            return new PillarChangeMove(pillar, PillarChangeMoveSelector.this.valueSelector.getVariableDescriptor(), toValue);
        }
    }

    private class OriginalPillarChangeMoveIterator
    extends UpcomingSelectionIterator<Move> {
        private Iterator<List<Object>> pillarIterator;
        private Iterator<Object> valueIterator;
        private List<Object> upcomingPillar;

        private OriginalPillarChangeMoveIterator() {
            this.pillarIterator = PillarChangeMoveSelector.this.pillarSelector.iterator();
            this.valueIterator = Iterators.emptyIterator();
        }

        @Override
        protected Move createUpcomingSelection() {
            if (!this.valueIterator.hasNext()) {
                if (!this.pillarIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
                this.upcomingPillar = this.pillarIterator.next();
                this.valueIterator = PillarChangeMoveSelector.this.valueSelector.iterator(this.upcomingPillar.get(0));
                if (!this.valueIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
            }
            Object toValue = this.valueIterator.next();
            return new PillarChangeMove(this.upcomingPillar, PillarChangeMoveSelector.this.valueSelector.getVariableDescriptor(), toValue);
        }
    }
}

