/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.meetingscheduling.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.impl.score.buildin.hardmediumsoft.HardMediumSoftScoreDefinition;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.meetingscheduling.domain.Attendance;
import org.optaplanner.examples.meetingscheduling.domain.Day;
import org.optaplanner.examples.meetingscheduling.domain.Meeting;
import org.optaplanner.examples.meetingscheduling.domain.MeetingAssignment;
import org.optaplanner.examples.meetingscheduling.domain.Person;
import org.optaplanner.examples.meetingscheduling.domain.Room;
import org.optaplanner.examples.meetingscheduling.domain.TimeGrain;
import org.optaplanner.persistence.xstream.impl.score.XStreamScoreConverter;

@PlanningSolution
@XStreamAlias(value="MsMeetingSchedule")
public class MeetingSchedule
extends AbstractPersistable
implements Solution<HardMediumSoftScore> {
    private List<Meeting> meetingList;
    private List<Day> dayList;
    private List<TimeGrain> timeGrainList;
    private List<Room> roomList;
    private List<Person> personList;
    private List<Attendance> attendanceList;
    private List<MeetingAssignment> meetingAssignmentList;
    @XStreamConverter(value=XStreamScoreConverter.class, types={HardMediumSoftScoreDefinition.class})
    private HardMediumSoftScore score;

    public List<Meeting> getMeetingList() {
        return this.meetingList;
    }

    public void setMeetingList(List<Meeting> meetingList) {
        this.meetingList = meetingList;
    }

    public List<Day> getDayList() {
        return this.dayList;
    }

    public void setDayList(List<Day> dayList) {
        this.dayList = dayList;
    }

    @ValueRangeProvider(id="timeGrainRange")
    public List<TimeGrain> getTimeGrainList() {
        return this.timeGrainList;
    }

    public void setTimeGrainList(List<TimeGrain> timeGrainList) {
        this.timeGrainList = timeGrainList;
    }

    @ValueRangeProvider(id="roomRange")
    public List<Room> getRoomList() {
        return this.roomList;
    }

    public void setRoomList(List<Room> roomList) {
        this.roomList = roomList;
    }

    public List<Person> getPersonList() {
        return this.personList;
    }

    public void setPersonList(List<Person> personList) {
        this.personList = personList;
    }

    public List<Attendance> getAttendanceList() {
        return this.attendanceList;
    }

    public void setAttendanceList(List<Attendance> attendanceList) {
        this.attendanceList = attendanceList;
    }

    @PlanningEntityCollectionProperty
    public List<MeetingAssignment> getMeetingAssignmentList() {
        return this.meetingAssignmentList;
    }

    public void setMeetingAssignmentList(List<MeetingAssignment> meetingAssignmentList) {
        this.meetingAssignmentList = meetingAssignmentList;
    }

    public HardMediumSoftScore getScore() {
        return this.score;
    }

    public void setScore(HardMediumSoftScore score) {
        this.score = score;
    }

    public Collection<? extends Object> getProblemFacts() {
        ArrayList<AbstractPersistable> facts = new ArrayList<AbstractPersistable>();
        facts.addAll(this.meetingList);
        facts.addAll(this.dayList);
        facts.addAll(this.timeGrainList);
        facts.addAll(this.roomList);
        facts.addAll(this.personList);
        facts.addAll(this.attendanceList);
        return facts;
    }
}

