/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.result;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.benchmark.impl.measurement.ScoreDifferencePercentage;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.BenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.PureSubSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.StatisticType;
import org.optaplanner.benchmark.impl.statistic.SubSingleStatistic;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.score.ScoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="subSingleBenchmarkResult")
public class SubSingleBenchmarkResult
implements BenchmarkResult {
    protected static final transient Logger logger = LoggerFactory.getLogger(SubSingleBenchmarkResult.class);
    @XStreamOmitField
    private SingleBenchmarkResult singleBenchmarkResult;
    private final int subSingleBenchmarkIndex;
    @XStreamImplicit(itemFieldName="pureSubSingleStatistic")
    private List<PureSubSingleStatistic> pureSubSingleStatisticList = null;
    @XStreamOmitField
    private Map<StatisticType, SubSingleStatistic> effectiveSubSingleStatisticMap;
    private Long usedMemoryAfterInputSolution = null;
    private Boolean succeeded = null;
    private Integer uninitializedVariableCount = null;
    private Score score = null;
    private long timeMillisSpent = -1L;
    private long calculateCount = -1L;
    private Score winningScoreDifference = null;
    private ScoreDifferencePercentage worstScoreDifferencePercentage = null;
    private Integer ranking = null;

    public SubSingleBenchmarkResult(SingleBenchmarkResult singleBenchmarkResult, int subSingleBenchmarkIndex) {
        this.singleBenchmarkResult = singleBenchmarkResult;
        this.subSingleBenchmarkIndex = subSingleBenchmarkIndex;
    }

    public List<PureSubSingleStatistic> getPureSubSingleStatisticList() {
        return this.pureSubSingleStatisticList;
    }

    public void setPureSubSingleStatisticList(List<PureSubSingleStatistic> pureSubSingleStatisticList) {
        this.pureSubSingleStatisticList = pureSubSingleStatisticList;
    }

    public void initSubSingleStatisticMap() {
        List<ProblemStatistic> problemStatisticList = this.singleBenchmarkResult.getProblemBenchmarkResult().getProblemStatisticList();
        this.effectiveSubSingleStatisticMap = new HashMap<StatisticType, SubSingleStatistic>(problemStatisticList.size() + this.pureSubSingleStatisticList.size());
        for (ProblemStatistic problemStatistic : problemStatisticList) {
            SubSingleStatistic subSingleStatistic = problemStatistic.createSubSingleStatistic(this);
            this.effectiveSubSingleStatisticMap.put(subSingleStatistic.getStatisticType(), subSingleStatistic);
        }
        for (PureSubSingleStatistic pureSubSingleStatistic : this.pureSubSingleStatisticList) {
            this.effectiveSubSingleStatisticMap.put(pureSubSingleStatistic.getStatisticType(), pureSubSingleStatistic);
        }
    }

    public SingleBenchmarkResult getSingleBenchmarkResult() {
        return this.singleBenchmarkResult;
    }

    public void setSingleBenchmarkResult(SingleBenchmarkResult singleBenchmarkResult) {
        this.singleBenchmarkResult = singleBenchmarkResult;
    }

    public int getSubSingleBenchmarkIndex() {
        return this.subSingleBenchmarkIndex;
    }

    public Map<StatisticType, SubSingleStatistic> getEffectiveSubSingleStatisticMap() {
        return this.effectiveSubSingleStatisticMap;
    }

    public Long getUsedMemoryAfterInputSolution() {
        return this.usedMemoryAfterInputSolution;
    }

    public void setUsedMemoryAfterInputSolution(Long usedMemoryAfterInputSolution) {
        this.usedMemoryAfterInputSolution = usedMemoryAfterInputSolution;
    }

    public Boolean getSucceeded() {
        return this.succeeded;
    }

    public void setSucceeded(Boolean succeeded) {
        this.succeeded = succeeded;
    }

    public Integer getUninitializedVariableCount() {
        return this.uninitializedVariableCount;
    }

    public void setUninitializedVariableCount(Integer uninitializedVariableCount) {
        this.uninitializedVariableCount = uninitializedVariableCount;
    }

    public Score getScore() {
        return this.score;
    }

    public void setScore(Score score) {
        this.score = score;
    }

    public long getTimeMillisSpent() {
        return this.timeMillisSpent;
    }

    public void setTimeMillisSpent(long timeMillisSpent) {
        this.timeMillisSpent = timeMillisSpent;
    }

    public long getCalculateCount() {
        return this.calculateCount;
    }

    public void setCalculateCount(long calculateCount) {
        this.calculateCount = calculateCount;
    }

    public Score getWinningScoreDifference() {
        return this.winningScoreDifference;
    }

    public void setWinningScoreDifference(Score winningScoreDifference) {
        this.winningScoreDifference = winningScoreDifference;
    }

    public ScoreDifferencePercentage getWorstScoreDifferencePercentage() {
        return this.worstScoreDifferencePercentage;
    }

    public void setWorstScoreDifferencePercentage(ScoreDifferencePercentage worstScoreDifferencePercentage) {
        this.worstScoreDifferencePercentage = worstScoreDifferencePercentage;
    }

    public Integer getRanking() {
        return this.ranking;
    }

    public void setRanking(Integer ranking) {
        this.ranking = ranking;
    }

    @Override
    public String getName() {
        return this.singleBenchmarkResult.getName() + "_" + this.subSingleBenchmarkIndex;
    }

    @Override
    public boolean hasAllSuccess() {
        return this.succeeded != null && this.succeeded != false;
    }

    public boolean isInitialized() {
        return this.uninitializedVariableCount != null && this.uninitializedVariableCount == 0;
    }

    @Override
    public boolean hasAnyFailure() {
        return this.succeeded != null && this.succeeded == false;
    }

    public boolean isScoreFeasible() {
        if (this.score instanceof FeasibilityScore) {
            return ((FeasibilityScore)this.score).isFeasible();
        }
        return true;
    }

    public Long getAverageCalculateCountPerSecond() {
        long timeMillisSpent = this.timeMillisSpent;
        if (timeMillisSpent == 0L) {
            timeMillisSpent = 1L;
        }
        return this.calculateCount * 1000L / timeMillisSpent;
    }

    public boolean isWinner() {
        return this.ranking != null && this.ranking == 0;
    }

    public SubSingleStatistic getSubSingleStatistic(StatisticType statisticType) {
        return this.effectiveSubSingleStatisticMap.get(statisticType);
    }

    public String getScoreWithUninitializedPrefix() {
        return ScoreUtils.getScoreWithUninitializedPrefix((int)this.uninitializedVariableCount, (Score)this.score);
    }

    @Override
    public Integer getAverageUninitializedVariableCount() {
        return this.getUninitializedVariableCount();
    }

    @Override
    public Score getAverageScore() {
        return this.getScore();
    }

    @Override
    public String getResultDirectoryName() {
        return "sub" + this.subSingleBenchmarkIndex;
    }

    @Override
    public File getResultDirectory() {
        return new File(this.singleBenchmarkResult.getResultDirectory(), this.getResultDirectoryName());
    }

    public void makeDirs() {
        File subSingleReportDirectory = this.getResultDirectory();
        subSingleReportDirectory.mkdirs();
    }

    public void accumulateResults(BenchmarkReport benchmarkReport) {
    }

    protected static SubSingleBenchmarkResult createMerge(SingleBenchmarkResult singleBenchmarkResult, SubSingleBenchmarkResult oldResult, int subSingleBenchmarkIndex) {
        SubSingleBenchmarkResult newResult = new SubSingleBenchmarkResult(singleBenchmarkResult, subSingleBenchmarkIndex);
        newResult.pureSubSingleStatisticList = new ArrayList<PureSubSingleStatistic>(oldResult.pureSubSingleStatisticList.size());
        for (PureSubSingleStatistic oldSubSingleStatistic : oldResult.pureSubSingleStatisticList) {
            newResult.pureSubSingleStatisticList.add(oldSubSingleStatistic.getStatisticType().buildPureSubSingleStatistic(newResult));
        }
        newResult.initSubSingleStatisticMap();
        for (SubSingleStatistic newSubSingleStatistic : newResult.effectiveSubSingleStatisticMap.values()) {
            SubSingleStatistic oldSubSingleStatistic = oldResult.getSubSingleStatistic(newSubSingleStatistic.getStatisticType());
            if (!oldSubSingleStatistic.getCsvFile().exists()) {
                if (oldResult.hasAnyFailure()) {
                    newSubSingleStatistic.initPointList();
                    logger.debug("Old result ({}) is a failure, skipping merge of it's sub single statistic ({}).", (Object)oldResult, (Object)oldSubSingleStatistic);
                    continue;
                }
                throw new IllegalStateException("Could not find old result's (" + oldResult + ") sub single statistic's (" + oldSubSingleStatistic + ") CSV file.");
            }
            oldSubSingleStatistic.unhibernatePointList();
            newSubSingleStatistic.setPointList(oldSubSingleStatistic.getPointList());
            oldSubSingleStatistic.hibernatePointList();
        }
        newResult.succeeded = oldResult.succeeded;
        newResult.score = oldResult.score;
        newResult.uninitializedVariableCount = oldResult.uninitializedVariableCount;
        newResult.timeMillisSpent = oldResult.timeMillisSpent;
        newResult.calculateCount = oldResult.calculateCount;
        singleBenchmarkResult.getSubSingleBenchmarkResultList().add(newResult);
        return newResult;
    }

    public String toString() {
        return this.getName();
    }
}

