/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.bestscore;

import java.util.List;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemBasedSubSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.bestscore.BestScoreStatisticPoint;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public class BestScoreSubSingleStatistic
extends ProblemBasedSubSingleStatistic<BestScoreStatisticPoint> {
    private final BestScoreSubSingleStatisticListener listener = new BestScoreSubSingleStatisticListener();

    public BestScoreSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        super(subSingleBenchmarkResult, ProblemStatisticType.BEST_SCORE);
    }

    @Override
    public void open(Solver<Solution> solver) {
        solver.addEventListener((SolverEventListener)this.listener);
    }

    @Override
    public void close(Solver<Solution> solver) {
        solver.removeEventListener((SolverEventListener)this.listener);
    }

    @Override
    protected String getCsvHeader() {
        return BestScoreStatisticPoint.buildCsvLine("timeMillisSpent", "score");
    }

    @Override
    protected BestScoreStatisticPoint createPointFromCsvLine(ScoreDefinition scoreDefinition, List<String> csvLine) {
        return new BestScoreStatisticPoint(Long.valueOf(csvLine.get(0)), scoreDefinition.parseScore(csvLine.get(1)));
    }

    private class BestScoreSubSingleStatisticListener
    implements SolverEventListener<Solution> {
        private BestScoreSubSingleStatisticListener() {
        }

        public void bestSolutionChanged(BestSolutionChangedEvent<Solution> event) {
            BestScoreSubSingleStatistic.this.pointList.add(new BestScoreStatisticPoint(event.getTimeMillisSpent(), event.getNewBestSolution().getScore()));
        }
    }
}

