/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.domain.solver;

import org.apache.commons.lang3.builder.CompareToBuilder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.tsp.domain.Domicile;
import org.optaplanner.examples.tsp.domain.TravelingSalesmanTour;
import org.optaplanner.examples.tsp.domain.Visit;

public class DomicileAngleVisitDifficultyWeightFactory
implements SelectionSorterWeightFactory<TravelingSalesmanTour, Visit> {
    public Comparable createSorterWeight(TravelingSalesmanTour vehicleRoutingSolution, Visit visit) {
        Domicile domicile = vehicleRoutingSolution.getDomicile();
        return new DomicileAngleVisitDifficultyWeight(visit, visit.getLocation().getAngle(domicile.getLocation()), visit.getLocation().getDistanceTo(domicile.getLocation()) + domicile.getLocation().getDistanceTo(visit.getLocation()));
    }

    public static class DomicileAngleVisitDifficultyWeight
    implements Comparable<DomicileAngleVisitDifficultyWeight> {
        private final Visit visit;
        private final double domicileAngle;
        private final long domicileRoundTripDistance;

        public DomicileAngleVisitDifficultyWeight(Visit visit, double domicileAngle, long domicileRoundTripDistance) {
            this.visit = visit;
            this.domicileAngle = domicileAngle;
            this.domicileRoundTripDistance = domicileRoundTripDistance;
        }

        @Override
        public int compareTo(DomicileAngleVisitDifficultyWeight other) {
            return new CompareToBuilder().append(this.domicileAngle, other.domicileAngle).append(this.domicileRoundTripDistance, other.domicileRoundTripDistance).append((Object)this.visit.getId(), (Object)other.visit.getId()).toComparison();
        }
    }
}

