/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.bendable;

import java.util.Arrays;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.bendable.BendableScoreHolder;
import org.optaplanner.core.config.score.trend.InitializingScoreTrendLevel;
import org.optaplanner.core.impl.score.definition.AbstractBendableScoreDefinition;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;

public class BendableScoreDefinition
extends AbstractBendableScoreDefinition<BendableScore> {
    public BendableScoreDefinition(int hardLevelsSize, int softLevelsSize) {
        super(hardLevelsSize, softLevelsSize);
    }

    @Override
    public Class<BendableScore> getScoreClass() {
        return BendableScore.class;
    }

    @Override
    public BendableScore parseScore(String scoreString) {
        return BendableScore.parseScore(this.hardLevelsSize, this.softLevelsSize, scoreString);
    }

    @Override
    public BendableScore fromLevelNumbers(Number[] levelNumbers) {
        if (levelNumbers.length != this.getLevelsSize()) {
            throw new IllegalStateException("The levelNumbers (" + Arrays.toString(levelNumbers) + ")'s length (" + levelNumbers.length + ") must equal the levelSize (" + this.getLevelsSize() + ").");
        }
        int[] hardScores = new int[this.hardLevelsSize];
        for (int i = 0; i < this.hardLevelsSize; ++i) {
            hardScores[i] = (Integer)levelNumbers[i];
        }
        int[] softScores = new int[this.softLevelsSize];
        for (int i = 0; i < this.softLevelsSize; ++i) {
            softScores[i] = (Integer)levelNumbers[this.hardLevelsSize + i];
        }
        return BendableScore.valueOf(hardScores, softScores);
    }

    public BendableScore createScore(int ... scores) {
        int levelsSize = this.hardLevelsSize + this.softLevelsSize;
        if (scores.length != levelsSize) {
            throw new IllegalArgumentException("The scores (" + Arrays.toString(scores) + ")'s length (" + scores.length + ") is not levelsSize (" + levelsSize + ").");
        }
        return BendableScore.valueOf(Arrays.copyOfRange(scores, 0, this.hardLevelsSize), Arrays.copyOfRange(scores, this.hardLevelsSize, levelsSize));
    }

    @Override
    public BendableScoreHolder buildScoreHolder(boolean constraintMatchEnabled) {
        return new BendableScoreHolder(constraintMatchEnabled, this.hardLevelsSize, this.softLevelsSize);
    }

    @Override
    public BendableScore buildOptimisticBound(InitializingScoreTrend initializingScoreTrend, BendableScore score) {
        InitializingScoreTrendLevel[] trendLevels = initializingScoreTrend.getTrendLevels();
        int[] hardScores = new int[this.hardLevelsSize];
        for (int i = 0; i < this.hardLevelsSize; ++i) {
            hardScores[i] = trendLevels[i] == InitializingScoreTrendLevel.ONLY_DOWN ? score.getHardScore(i) : Integer.MAX_VALUE;
        }
        int[] softScores = new int[this.softLevelsSize];
        for (int i = 0; i < this.softLevelsSize; ++i) {
            softScores[i] = trendLevels[this.hardLevelsSize + i] == InitializingScoreTrendLevel.ONLY_DOWN ? score.getSoftScore(i) : Integer.MAX_VALUE;
        }
        return BendableScore.valueOf(hardScores, softScores);
    }

    @Override
    public BendableScore buildPessimisticBound(InitializingScoreTrend initializingScoreTrend, BendableScore score) {
        InitializingScoreTrendLevel[] trendLevels = initializingScoreTrend.getTrendLevels();
        int[] hardScores = new int[this.hardLevelsSize];
        for (int i = 0; i < this.hardLevelsSize; ++i) {
            hardScores[i] = trendLevels[i] == InitializingScoreTrendLevel.ONLY_UP ? score.getHardScore(i) : Integer.MIN_VALUE;
        }
        int[] softScores = new int[this.softLevelsSize];
        for (int i = 0; i < this.softLevelsSize; ++i) {
            softScores[i] = trendLevels[this.hardLevelsSize + i] == InitializingScoreTrendLevel.ONLY_UP ? score.getSoftScore(i) : Integer.MIN_VALUE;
        }
        return BendableScore.valueOf(hardScores, softScores);
    }
}

