/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.app;

import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.persistence.CloudBalancingDao;
import org.optaplanner.examples.cloudbalancing.swingui.CloudBalancingPanel;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.persistence.SolutionDao;
import org.optaplanner.examples.common.swingui.SolutionPanel;

public class CloudBalancingApp
extends CommonApp<CloudBalance> {
    public static final String SOLVER_CONFIG = "org/optaplanner/examples/cloudbalancing/solver/cloudBalancingSolverConfig.xml";

    public static void main(String[] args) {
        CloudBalancingApp.prepareSwingEnvironment();
        new CloudBalancingApp().init();
    }

    public CloudBalancingApp() {
        super("Cloud balancing", "Assign processes to computers.\n\nEach computer must have enough hardware to run all of its processes.\nEach used computer inflicts a maintenance cost.", SOLVER_CONFIG, "/org/optaplanner/examples/cloudbalancing/swingui/cloudBalancingLogo.png");
    }

    @Override
    protected Solver<CloudBalance> createSolver() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)SOLVER_CONFIG);
        return solverFactory.buildSolver();
    }

    @Override
    protected SolutionPanel createSolutionPanel() {
        return new CloudBalancingPanel();
    }

    @Override
    protected SolutionDao createSolutionDao() {
        return new CloudBalancingDao();
    }
}

