/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.travelingtournament.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.components.LabeledComboBoxRenderer;
import org.optaplanner.examples.common.swingui.timetable.TimeTablePanel;
import org.optaplanner.examples.travelingtournament.domain.Day;
import org.optaplanner.examples.travelingtournament.domain.Match;
import org.optaplanner.examples.travelingtournament.domain.Team;
import org.optaplanner.examples.travelingtournament.domain.TravelingTournament;
import org.optaplanner.swing.impl.SwingUtils;
import org.optaplanner.swing.impl.TangoColorFactory;

public class TravelingTournamentPanel
extends SolutionPanel {
    public static final String LOGO_PATH = "/org/optaplanner/examples/travelingtournament/swingui/travelingTournamentLogo.png";
    private final TimeTablePanel<Team, Day> teamsPanel;
    private TangoColorFactory tangoColorFactory;

    public TravelingTournamentPanel() {
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        this.teamsPanel = new TimeTablePanel();
        tabbedPane.add("Teams", new JScrollPane(this.teamsPanel));
        this.add((Component)tabbedPane, "Center");
        this.setPreferredSize(PREFERRED_SCROLLABLE_VIEWPORT_SIZE);
    }

    @Override
    public boolean isWrapInScrollPane() {
        return false;
    }

    @Override
    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    private TravelingTournament getTravelingTournament() {
        return (TravelingTournament)this.solutionBusiness.getSolution();
    }

    @Override
    public void resetPanel(Solution solution) {
        this.teamsPanel.reset();
        TravelingTournament travelingTournament = (TravelingTournament)solution;
        this.tangoColorFactory = new TangoColorFactory();
        this.defineGrid(travelingTournament);
        this.fillCells(travelingTournament);
        this.repaint();
    }

    private void defineGrid(TravelingTournament travelingTournament) {
        JButton footprint = SwingUtils.makeSmallButton((JButton)new JButton("MMMMM"));
        int footprintWidth = footprint.getPreferredSize().width;
        this.teamsPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN);
        for (Team team : travelingTournament.getTeamList()) {
            this.teamsPanel.defineColumnHeader(team, footprintWidth);
        }
        this.teamsPanel.defineColumnHeader(null, footprintWidth);
        this.teamsPanel.defineRowHeaderByKey(TimeTablePanel.HeaderRowKey.HEADER_ROW);
        for (Day day : travelingTournament.getDayList()) {
            this.teamsPanel.defineRowHeader(day);
        }
        this.teamsPanel.defineRowHeader(null);
    }

    private void fillCells(TravelingTournament travelingTournament) {
        this.teamsPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Day")));
        this.fillTeamCells(travelingTournament);
        this.fillDayCells(travelingTournament);
        this.fillMatchCells(travelingTournament);
    }

    private void fillTeamCells(TravelingTournament travelingTournament) {
        for (Team team : travelingTournament.getTeamList()) {
            JPanel teamPanel = this.createTableHeader(new JLabel(team.getLabel(), 0));
            teamPanel.setBackground(this.tangoColorFactory.pickColor((Object)team));
            this.teamsPanel.addColumnHeader(team, TimeTablePanel.HeaderRowKey.HEADER_ROW, teamPanel);
        }
        this.teamsPanel.addColumnHeader(null, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Unassigned", 0)));
    }

    private void fillDayCells(TravelingTournament travelingTournament) {
        for (Day day : travelingTournament.getDayList()) {
            this.teamsPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, day, this.createTableHeader(new JLabel(day.getLabel())));
        }
        this.teamsPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, null, this.createTableHeader(new JLabel("Unassigned")));
    }

    private void fillMatchCells(TravelingTournament travelingTournament) {
        for (Match match : travelingTournament.getMatchList()) {
            Team homeTeam = match.getHomeTeam();
            Team awayTeam = match.getAwayTeam();
            this.teamsPanel.addCell(homeTeam, match.getDay(), this.createButton(match, this.tangoColorFactory.pickColor((Object)awayTeam), awayTeam.getLabel()));
            this.teamsPanel.addCell(awayTeam, match.getDay(), this.createButton(match, this.tangoColorFactory.pickColor((Object)homeTeam), homeTeam.getLabel()));
        }
    }

    private JPanel createTableHeader(JLabel label) {
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.add((Component)label, "North");
        headerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(TangoColorFactory.ALUMINIUM_5), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        return headerPanel;
    }

    private JButton createButton(Match match, Color color, String label) {
        JButton button = SwingUtils.makeSmallButton((JButton)new JButton(new MatchAction(match, label)));
        button.setBackground(color);
        return button;
    }

    private class MatchAction
    extends AbstractAction {
        private Match match;

        public MatchAction(Match match, String label) {
            super(label);
            this.match = match;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Day> dayList = TravelingTournamentPanel.this.getTravelingTournament().getDayList();
            JComboBox<Object> dayListField = new JComboBox<Object>(dayList.toArray(new Object[dayList.size() + 1]));
            LabeledComboBoxRenderer.applyToComboBox(dayListField);
            dayListField.setSelectedItem(this.match.getDay());
            int result = JOptionPane.showConfirmDialog(TravelingTournamentPanel.this.getRootPane(), dayListField, "Select day", 2);
            if (result == 0) {
                Day toDay = (Day)dayListField.getSelectedItem();
                TravelingTournamentPanel.this.solutionBusiness.doChangeMove(this.match, "day", toDay);
                TravelingTournamentPanel.this.solverAndPersistenceFrame.resetScreen();
            }
        }
    }
}

