/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.constraint;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.builder.CompareToBuilder;

public abstract class ConstraintMatch
implements Serializable,
Comparable<ConstraintMatch> {
    protected final String constraintPackage;
    protected final String constraintName;
    protected final int scoreLevel;
    protected final List<Object> justificationList;

    protected ConstraintMatch(String constraintPackage, String constraintName, int scoreLevel, List<Object> justificationList) {
        this.constraintPackage = constraintPackage;
        this.constraintName = constraintName;
        this.scoreLevel = scoreLevel;
        this.justificationList = justificationList;
    }

    public String getConstraintPackage() {
        return this.constraintPackage;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public int getScoreLevel() {
        return this.scoreLevel;
    }

    public List<Object> getJustificationList() {
        return this.justificationList;
    }

    public abstract Number getWeightAsNumber();

    public String getIdentificationString() {
        return this.constraintPackage + "/" + this.constraintName + "/level" + this.scoreLevel + "/" + this.justificationList;
    }

    @Override
    public int compareTo(ConstraintMatch other) {
        return new CompareToBuilder().append((Object)this.getConstraintPackage(), (Object)other.getConstraintPackage()).append((Object)this.getConstraintName(), (Object)other.getConstraintName()).append(this.getScoreLevel(), other.getScoreLevel()).append(this.getJustificationList(), other.getJustificationList()).append((Object)this.getWeightAsNumber(), (Object)other.getWeightAsNumber()).toComparison();
    }

    public String toString() {
        return this.getIdentificationString() + "=" + this.getWeightAsNumber();
    }
}

