/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.phase;

import java.util.Iterator;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.phase.Phase;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleSupport;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPhase
implements Phase {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected int phaseIndex = -1;
    protected Termination termination;
    protected BestSolutionRecaller bestSolutionRecaller;
    protected PhaseLifecycleSupport phaseLifecycleSupport = new PhaseLifecycleSupport();

    public Termination getTermination() {
        return this.termination;
    }

    public int getPhaseIndex() {
        return this.phaseIndex;
    }

    public void setPhaseIndex(int phaseIndex) {
        this.phaseIndex = phaseIndex;
    }

    public void setTermination(Termination termination) {
        this.termination = termination;
    }

    public void setBestSolutionRecaller(BestSolutionRecaller bestSolutionRecaller) {
        this.bestSolutionRecaller = bestSolutionRecaller;
    }

    public abstract String getPhaseTypeString();

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        this.termination.solvingStarted(solverScope);
        this.phaseLifecycleSupport.fireSolvingStarted(solverScope);
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        this.termination.solvingEnded(solverScope);
        this.phaseLifecycleSupport.fireSolvingEnded(solverScope);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope phaseScope) {
        phaseScope.reset();
        this.bestSolutionRecaller.phaseStarted(phaseScope);
        this.termination.phaseStarted(phaseScope);
        this.phaseLifecycleSupport.firePhaseStarted(phaseScope);
    }

    @Override
    public void stepStarted(AbstractStepScope stepScope) {
        this.bestSolutionRecaller.stepStarted(stepScope);
        this.termination.stepStarted(stepScope);
        this.phaseLifecycleSupport.fireStepStarted(stepScope);
    }

    @Override
    public void stepEnded(AbstractStepScope stepScope) {
        this.bestSolutionRecaller.stepEnded(stepScope);
        this.termination.stepEnded(stepScope);
        this.phaseLifecycleSupport.fireStepEnded(stepScope);
    }

    @Override
    public void phaseEnded(AbstractPhaseScope phaseScope) {
        this.bestSolutionRecaller.phaseEnded(phaseScope);
        this.termination.phaseEnded(phaseScope);
        this.phaseLifecycleSupport.firePhaseEnded(phaseScope);
    }

    @Override
    public void addPhaseLifecycleListener(PhaseLifecycleListener phaseLifecycleListener) {
        this.phaseLifecycleSupport.addEventListener(phaseLifecycleListener);
    }

    @Override
    public void removePhaseLifecycleListener(PhaseLifecycleListener phaseLifecycleListener) {
        this.phaseLifecycleSupport.removeEventListener(phaseLifecycleListener);
    }

    protected void assertWorkingSolutionInitialized(AbstractPhaseScope phaseScope) {
        InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
        SolutionDescriptor solutionDescriptor = scoreDirector.getSolutionDescriptor();
        Solution workingSolution = scoreDirector.getWorkingSolution();
        Iterator<Object> it = solutionDescriptor.extractAllEntitiesIterator(workingSolution);
        while (it.hasNext()) {
            Object entity = it.next();
            if (solutionDescriptor.isEntityInitializedOrImmovable(scoreDirector, entity)) continue;
            EntityDescriptor entityDescriptor = solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            String variableRef = null;
            for (GenuineVariableDescriptor variableDescriptor : entityDescriptor.getGenuineVariableDescriptors()) {
                if (variableDescriptor.isInitialized(entity)) continue;
                variableRef = variableDescriptor.getSimpleEntityAndVariableName();
                break;
            }
            throw new IllegalStateException(this.getPhaseTypeString() + " phase (" + this.phaseIndex + ") needs to start from an initialized solution, but the planning variable (" + variableRef + ") is uninitialized for the entity (" + entity + ").\n" + "  Initialize the solution by configuring a Construction Heuristic phase before this phase.");
        }
    }
}

